/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4);
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.shared.ui.dnd.criteria;

/**
 * Comparison operator for drag and drop acceptance criterion.
 *
 * @author Vaadin Ltd.
 * @since 8.1
 */
public enum ComparisonOperator {

    /**
     * Smaller than operator ("<").
     */
    SMALLER_THAN,

    /**
     * Smaller than or equals to operator ("<=").
     */
    SMALLER_THAN_OR_EQUALS,

    /**
     * Equals to operator ("==").
     */
    EQUALS,

    /**
     * Greater than or equals to operator (">=").
     */
    GREATER_THAN_OR_EQUALS,

    /**
     * Greater than operator (">").
     */
    GREATER_THAN,

    /**
     * Not equals operator ("!=").
     */
    NOT_EQUALS
}
