/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.nativeselect;

import com.vaadin.shared.annotations.DelegateToWidget;
import com.vaadin.shared.ui.AbstractSingleSelectState;

/**
 * Shared state for {@code NativeSelect}.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.0
 */
public class NativeSelectState extends AbstractSingleSelectState {

    /**
     * The default primary style name for {@code NativeSelect}.
     */
    public static final String STYLE_NAME = "v-select";

    /**
     * True to allow selecting nothing (a special empty selection item is shown
     * at the beginning of the list), false not to allow empty selection by the
     * user.
     */
    public boolean emptySelectionAllowed = true;

    /**
     * Caption for item which represents empty selection.
     */
    public String emptySelectionCaption = "";

    /**
     * The number of items that are visible. If only one item is visible, then
     * the box will be displayed as a drop-down list.
     *
     * @since 8.1
     */
    @DelegateToWidget
    public int visibleItemCount = 1;

    {
        primaryStyleName = STYLE_NAME;
    }
}
