/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.navigator;

import com.vaadin.navigator.NavigationStateManager;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.spring.annotation.UIScope;
import com.vaadin.spring.navigator.SpringViewProvider;
import com.vaadin.spring.navigator.ViewActivationListener;
import com.vaadin.spring.server.SpringVaadinServletService;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.ApplicationContext;

@UIScope
public class SpringNavigator
extends Navigator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringNavigator.class);
    @Autowired
    private transient ApplicationContext applicationContext;
    @Autowired
    private SpringViewProvider viewProvider;
    private String currentViewName;
    private final List<ViewActivationListener> activationListeners = new LinkedList<ViewActivationListener>();

    public SpringNavigator() {
    }

    public SpringNavigator(UI ui, ComponentContainer container) {
        super(ui, container);
    }

    public SpringNavigator(UI ui, NavigationStateManager stateManager, ViewDisplay display) {
        super(ui, stateManager, display);
    }

    public SpringNavigator(UI ui, SingleComponentContainer container) {
        super(ui, container);
    }

    public SpringNavigator(UI ui, ViewDisplay display) {
        super(ui, display);
    }

    private void fireActivationEvent(String viewName, boolean active) {
        ArrayList<ViewActivationListener> listeners = new ArrayList<ViewActivationListener>(this.activationListeners);
        ViewActivationListener.ViewActivationEvent event = new ViewActivationListener.ViewActivationEvent((Object)this, active, viewName);
        for (ViewActivationListener listener : listeners) {
            listener.viewActivated(event);
        }
    }

    public void addViewActivationListener(ViewActivationListener listener) {
        this.activationListeners.add(listener);
    }

    public void removeViewActivationListener(ViewActivationListener listener) {
        this.activationListeners.remove(listener);
    }

    protected void switchView(ViewChangeListener.ViewChangeEvent event) {
        boolean viewNameChanged;
        String viewName = event.getViewName();
        boolean bl = viewNameChanged = !viewName.equals(this.currentViewName);
        if (viewNameChanged && this.currentViewName != null) {
            this.fireActivationEvent(this.currentViewName, false);
        }
        super.switchView(event);
        if (viewNameChanged) {
            this.currentViewName = viewName;
            this.fireActivationEvent(this.currentViewName, true);
        }
    }

    public void init(UI ui, ComponentContainer container) {
        this.init(ui, (ViewDisplay)new Navigator.ComponentContainerViewDisplay(container));
    }

    public void init(UI ui, SingleComponentContainer container) {
        this.init(ui, (ViewDisplay)new Navigator.SingleComponentContainerViewDisplay(container));
    }

    public void init(UI ui, ViewDisplay display) {
        this.init(ui, (NavigationStateManager)new Navigator.UriFragmentManager(ui.getPage()), display);
    }

    public void init(UI ui, NavigationStateManager stateManager, ViewDisplay display) {
        super.init(ui, stateManager, display);
        this.addProvider(this.viewProvider);
    }

    public void setErrorView(final Class<? extends View> viewClass) {
        BeanDefinition beanDefinition;
        String scope;
        if (viewClass == null) {
            this.setErrorProvider(null);
            return;
        }
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.getWebApplicationContext(), viewClass);
        if (beanNames.length > 1) {
            throw new NoUniqueBeanDefinitionException(viewClass, new String[0]);
        }
        if (beanNames.length == 1 && !"vaadin-ui".equals(scope = (beanDefinition = this.viewProvider.getBeanDefinitionRegistry().getBeanDefinition(beanNames[0])).getScope()) && !"prototype".equals(scope)) {
            throw new BeanDefinitionValidationException("Error view must have UI or prototype scope");
        }
        this.setErrorProvider(new ViewProvider(){

            public View getView(String viewName) {
                try {
                    return (View)SpringNavigator.this.getWebApplicationContext().getBean(viewClass);
                }
                catch (NoUniqueBeanDefinitionException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    LOGGER.info("Could not find error view bean of class [{}] in application context, creating it with Class.newInstance()", (Object)viewClass.getName());
                    try {
                        return (View)viewClass.newInstance();
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }

            public String getViewName(String navigationState) {
                return navigationState;
            }
        });
    }

    protected ApplicationContext getWebApplicationContext() {
        if (this.applicationContext == null) {
            UI ui = UI.getCurrent();
            if (ui == null) {
                throw new IllegalStateException("Could not find application context and no current UI is available");
            }
            this.applicationContext = ((SpringVaadinServletService)ui.getSession().getService()).getWebApplicationContext();
        }
        return this.applicationContext;
    }
}

