/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.protocol;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.changepw.ChangePasswordConfiguration;
import org.apache.directory.server.changepw.messages.ChangePasswordErrorModifier;
import org.apache.directory.server.changepw.messages.ChangePasswordRequest;
import org.apache.directory.server.changepw.protocol.ChangePasswordProtocolCodecFactory;
import org.apache.directory.server.changepw.service.ChangePasswordChain;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessage;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessageModifier;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePasswordProtocolHandler
implements IoHandler {
    private static final Logger log = LoggerFactory.getLogger(ChangePasswordProtocolHandler.class);
    private ChangePasswordConfiguration config;
    private PrincipalStore store;
    private IoHandlerCommand changepwService;
    private String contextKey = "context";

    public ChangePasswordProtocolHandler(ChangePasswordConfiguration config, PrincipalStore store) {
        this.config = config;
        this.store = store;
        this.changepwService = new ChangePasswordChain();
    }

    public void sessionCreated(IoSession session) throws Exception {
        log.debug("{} CREATED", (Object)session.getRemoteAddress());
        session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)ChangePasswordProtocolCodecFactory.getInstance()));
    }

    public void sessionOpened(IoSession session) {
        log.debug("{} OPENED", (Object)session.getRemoteAddress());
    }

    public void sessionClosed(IoSession session) {
        log.debug("{} CLOSED", (Object)session.getRemoteAddress());
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        log.debug("{} IDLE({})", (Object)session.getRemoteAddress(), (Object)status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.debug(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close();
    }

    public void messageReceived(IoSession session, Object message) {
        log.debug("{} RCVD: {}", (Object)session.getRemoteAddress(), message);
        InetAddress clientAddress = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
        ChangePasswordRequest request = (ChangePasswordRequest)message;
        try {
            ChangePasswordContext changepwContext = new ChangePasswordContext();
            changepwContext.setConfig(this.config);
            changepwContext.setStore(this.store);
            changepwContext.setClientAddress(clientAddress);
            changepwContext.setRequest(request);
            session.setAttribute(this.getContextKey(), (Object)changepwContext);
            this.changepwService.execute(null, session, message);
            session.write((Object)changepwContext.getReply());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            KerberosException ke = (KerberosException)((Object)e);
            ErrorMessage errorMessage = this.getErrorMessage(this.config.getChangepwPrincipal(), ke);
            ChangePasswordErrorModifier modifier = new ChangePasswordErrorModifier();
            modifier.setErrorMessage(errorMessage);
            session.write((Object)modifier.getChangePasswordError());
        }
    }

    public void messageSent(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug("{} SENT: {}", (Object)session.getRemoteAddress(), message);
        }
    }

    public String getContextKey() {
        return this.contextKey;
    }

    private ErrorMessage getErrorMessage(KerberosPrincipal principal, KerberosException exception) {
        ErrorMessageModifier modifier = new ErrorMessageModifier();
        KerberosTime now = new KerberosTime();
        modifier.setErrorCode(exception.getErrorCode());
        modifier.setExplanatoryText(exception.getMessage());
        modifier.setServerPrincipal(principal);
        modifier.setServerTime(now);
        modifier.setServerMicroSecond(0);
        modifier.setExplanatoryData(this.buildExplanatoryData(exception));
        return modifier.getErrorMessage();
    }

    private byte[] buildExplanatoryData(KerberosException exception) {
        short resultCode = (short)exception.getErrorCode();
        byte[] resultString = new byte[]{0};
        if (exception.getExplanatoryData() == null || exception.getExplanatoryData().length == 0) {
            try {
                resultString = exception.getMessage().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                log.error(uee.getMessage());
            }
        } else {
            resultString = exception.getExplanatoryData();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        byteBuffer.putShort(resultCode);
        byteBuffer.put(resultString);
        byteBuffer.flip();
        byte[] explanatoryData = new byte[byteBuffer.remaining()];
        byteBuffer.get(explanatoryData, 0, explanatoryData.length);
        return explanatoryData;
    }
}

