/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.directory.server.tools.BaseCommand;
import org.apache.directory.server.tools.InstanceLayout;
import org.apache.directory.server.tools.ToolCommand;

public class ApachedsTools {
    public static void main(String[] args) throws Exception {
        CommandLine cmdline;
        String command;
        BaseCommand tools = ApachedsTools.getInstance();
        if (!BaseCommand.hasBannerOption(args)) {
            tools.printBanner();
        }
        if (args.length == 0) {
            System.err.println("Type " + tools.getProductCommand() + " help for usage.");
            System.exit(1);
        }
        if ("help".equals(command = args[0].toLowerCase())) {
            CommandLine cmdline2 = tools.getCommandLine(command, args);
            if (cmdline2.getArgs().length > 1) {
                tools.helpOnCommand(cmdline2.getArgs()[1]);
                System.exit(0);
            } else {
                tools.printUsage();
                System.exit(0);
            }
        } else if (command.equals("-version")) {
            System.out.println(tools.getProductCommand() + " version " + tools.getProductVersion());
            System.exit(0);
        }
        ToolCommand cmd = (ToolCommand)tools.getCommands().get(command);
        if (cmd == null) {
            System.err.println("Unknown command: " + args[0]);
            System.err.println("Type " + tools.getProductCommand() + " help for usage.");
            System.exit(1);
        }
        if ((cmdline = tools.getCommandLine(command, args)).hasOption('d')) {
            cmd.setDebugEnabled(true);
            BaseCommand.dumpArgs("raw command line arguments: ", args);
            BaseCommand.dumpArgs("parsed arguments: ", cmdline.getArgs());
        }
        cmd.setQuietEnabled(cmdline.hasOption('q'));
        cmd.setDebugEnabled(cmdline.hasOption('d'));
        cmd.setVerboseEnabled(cmdline.hasOption('v'));
        cmd.setVersion(tools.getProductVersion());
        if (cmdline.getOptionValue('i') != null) {
            cmd.setLayout(cmdline.getOptionValue('i'));
        } else if (cmdline.hasOption('c')) {
            System.err.println("forced configuration load (-c) requires the -i option");
            System.exit(1);
        }
        if (cmdline.getOptionValue('z') != null) {
            cmd.setInstanceLayout(new InstanceLayout(new File(cmdline.getOptionValue('z'))));
        }
        cmd.execute(cmdline);
    }

    public static BaseCommand getInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Properties props = new Properties();
        try {
            props.load(BaseCommand.class.getResourceAsStream("product.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String productVersion = props.getProperty("product.version", "UNKNOWN");
        String productUrl = props.getProperty("product.url", "http://directory.apache.org");
        String productDisplayName = props.getProperty("product.display.name", "Apache Directory Server");
        String productCommand = props.getProperty("product.command", "apacheds-tools");
        String productBanner = props.getProperty("product.banner", "       _                     _          ____  ____    _____           _      \n      / \\   _ __   __ _  ___| |__   ___|  _ \\/ ___|  |_   _|__   ___ | |___  \n     / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ | | \\___ \\    | |/ _ \\ / _ \\| / __| \n    / ___ \\| |_) | (_| | (__| | | |  __/ |_| |___) |   | | (_) | (_) | \\__ \\ \n   /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|____/|____/    |_|\\___/ \\___/|_|___/ \n           |_|                                                               \n");
        String productClass = props.getProperty("product.class", "org.apache.directory.server.tools.BaseCommand");
        BaseCommand baseCommand = (BaseCommand)Class.forName(productClass).newInstance();
        baseCommand.setProductBanner(productBanner);
        baseCommand.setProductDisplayName(productDisplayName);
        baseCommand.setProductUrl(productUrl);
        baseCommand.setProductVersion(productVersion);
        baseCommand.setProductCommand(productCommand);
        return baseCommand;
    }
}

