/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.directory.server.tools.CapacityTestCommand;
import org.apache.directory.server.tools.DiagnosticCommand;
import org.apache.directory.server.tools.DisconnectNotificationCommand;
import org.apache.directory.server.tools.DumpCommand;
import org.apache.directory.server.tools.GracefulShutdownCommand;
import org.apache.directory.server.tools.ImportCommand;
import org.apache.directory.server.tools.IndexCommand;
import org.apache.directory.server.tools.ToolCommand;

public class BaseCommand {
    private Map commands = new HashMap();
    private List commandsOrdered = new ArrayList();
    private Options global = new Options();
    private String productCommand;
    private String productVersion;
    private String productDisplayName;
    private String productUrl;
    private String productBanner;
    static final String BANNER = "       _                     _          ____  ____    _____           _      \n      / \\   _ __   __ _  ___| |__   ___|  _ \\/ ___|  |_   _|__   ___ | |___  \n     / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ | | \\___ \\    | |/ _ \\ / _ \\| / __| \n    / ___ \\| |_) | (_| | (__| | | |  __/ |_| |___) |   | | (_) | (_) | \\__ \\ \n   /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|____/|____/    |_|\\___/ \\___/|_|___/ \n           |_|                                                               \n";

    public BaseCommand() {
        this.init();
    }

    protected void init() {
        ToolCommand command = new DiagnosticCommand();
        this.commands.put(command.getName(), command);
        this.commandsOrdered.add(command.getName());
        command = new DisconnectNotificationCommand();
        this.commands.put(command.getName(), command);
        this.commandsOrdered.add(command.getName());
        command = new DumpCommand();
        this.commands.put(command.getName(), command);
        this.commandsOrdered.add(command.getName());
        command = new CapacityTestCommand();
        this.commands.put(command.getName(), command);
        this.commandsOrdered.add(command.getName());
        command = new GracefulShutdownCommand();
        this.commands.put(command.getName(), command);
        this.commandsOrdered.add(command.getName());
        command = new ImportCommand();
        this.commands.put(command.getName(), command);
        this.commandsOrdered.add(command.getName());
        command = new IndexCommand();
        this.commands.put(command.getName(), command);
        this.commandsOrdered.add(command.getName());
        Option op = new Option("i", "install-path", true, "path to installation directory");
        this.getGlobal().addOption(op);
        op = new Option("z", "instance-path", true, "path to ADS instance directory");
        this.getGlobal().addOption(op);
        op = new Option("b", "banner", false, "suppress banner print outs");
        this.getGlobal().addOption(op);
        op = new Option("d", "debug", false, "toggle debug mode");
        this.getGlobal().addOption(op);
        op = new Option("v", "verbose", false, "toggle verbose debugging");
        this.getGlobal().addOption(op);
        op = new Option("q", "quiet", false, "keep the noise down to a minimum");
        this.getGlobal().addOption(op);
        op = new Option("c", "configuration", false, "force loading the server.xml (requires -i)");
        this.getGlobal().addOption(op);
        op = new Option("version", false, "print the version information and exit");
        this.getGlobal().addOption(op);
    }

    public static boolean hasBannerOption(String[] args) {
        for (int ii = 0; ii < args.length; ++ii) {
            if (!args[ii].equals("-b") && !args[ii].equals("-banner")) continue;
            return true;
        }
        return false;
    }

    public CommandLine getCommandLine(String command, String[] args) {
        Options all = this.allOptions(command);
        PosixParser parser = new PosixParser();
        CommandLine cmdline = null;
        try {
            cmdline = parser.parse(all, args);
        }
        catch (AlreadySelectedException ase) {
            System.err.println("Command line parsing failed for " + command + ".  Reason: already selected " + ase.getMessage());
            System.exit(1);
        }
        catch (MissingArgumentException mae) {
            System.err.println("Command line parsing failed for " + command + ".  Reason: missing argument " + mae.getMessage());
            System.exit(1);
        }
        catch (MissingOptionException moe) {
            System.err.println("Command line parsing failed for " + command + ".  Reason: missing option " + moe.getMessage());
            System.exit(1);
        }
        catch (UnrecognizedOptionException uoe) {
            System.err.println("Command line parsing failed for " + command + ".  Reason: unrecognized option" + uoe.getMessage());
            System.exit(1);
        }
        catch (ParseException pe) {
            System.err.println("Command line parsing failed for " + command + ".  Reason: " + ((Object)((Object)pe)).getClass());
            System.exit(1);
        }
        return cmdline;
    }

    public Options allOptions(String command) {
        if (command.equals("help")) {
            return this.getGlobal();
        }
        Options all = new Options();
        ToolCommand cmd = (ToolCommand)this.getCommands().get(command);
        Iterator ii = this.getGlobal().getOptions().iterator();
        while (ii.hasNext()) {
            all.addOption((Option)ii.next());
        }
        ii = cmd.getOptions().getOptions().iterator();
        while (ii.hasNext()) {
            all.addOption((Option)ii.next());
        }
        return all;
    }

    public static void dumpArgs(String msg, String[] args) {
        if (args.length == 0) {
            System.out.println(msg);
            System.out.println("\t NONE");
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(msg).append("\n");
        for (int ii = 0; ii < args.length; ++ii) {
            buf.append("\targs[" + ii + "] = ").append(args[ii]).append("\n");
        }
        System.out.println(buf);
    }

    public void helpOnCommand(String command) {
        if (command.equals("help")) {
            this.printUsage();
            System.exit(0);
        }
        if (this.getCommands().containsKey(command)) {
            ToolCommand cmd = (ToolCommand)this.getCommands().get(command);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(this.getProductCommand() + " " + cmd + " [options]", cmd.getOptions());
        } else {
            System.err.println(command + ": unknown command");
            System.exit(1);
        }
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getProductCommand() + " <command> [options]", "\nGlobal options:", this.getGlobal(), "\nType \"" + this.getProductCommand() + " help <command>\" for help on a command.");
        System.out.println("\nAvailable commands:");
        Iterator it = this.commandsOrdered.iterator();
        System.out.println("\thelp");
        while (it.hasNext()) {
            System.out.println("\t" + it.next());
        }
        System.out.println("\nThese tools are used to manage " + this.getProductDisplayName() + ".");
        System.out.println("For additional information, see " + this.getProductUrl());
    }

    public void printBanner() {
        System.out.println(this.getProductBanner());
    }

    public void setProductCommand(String productCommand) {
        this.productCommand = productCommand;
    }

    public String getProductCommand() {
        return this.productCommand;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductDisplayName(String productDisplayName) {
        this.productDisplayName = productDisplayName;
    }

    public String getProductDisplayName() {
        return this.productDisplayName;
    }

    public void setProductUrl(String productUrl) {
        this.productUrl = productUrl;
    }

    public String getProductUrl() {
        return this.productUrl;
    }

    public void setProductBanner(String productBanner) {
        this.productBanner = productBanner;
    }

    public String getProductBanner() {
        return this.productBanner;
    }

    public void setCommands(Map commands) {
        this.commands = commands;
    }

    public Map getCommands() {
        return this.commands;
    }

    public void setGlobal(Options global) {
        this.global = global;
    }

    public Options getGlobal() {
        return this.global;
    }
}

