/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.directory.server.tools.ToolCommand;

public class CapacityTestCommand
extends ToolCommand {
    public static final String PORT_RANGE = "(1, 49151)";
    private int port = 10389;
    private String host = "localhost";
    private String password = "secret";
    private String baseDn = "ou=users,dc=example,dc=com";

    public CapacityTestCommand() {
        super("capacity");
    }

    public void execute(CommandLine cmdline) throws Exception {
        this.processOptions(cmdline);
        this.getLayout().verifyInstallation();
        String outputFile = cmdline.getOptionValue('f');
        PrintWriter out = null;
        out = outputFile == null ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(outputFile));
        if (this.isDebugEnabled()) {
            out.println("Parameters for capacity extended request:");
            out.println("port = " + this.port);
            out.println("host = " + this.host);
            out.println("password = " + this.password);
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + this.host + ":" + this.port);
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", this.password);
        env.put("java.naming.security.authentication", "simple");
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        this.createBase(ctx);
        StringBuffer dnBuf = new StringBuffer();
        StringBuffer outBuf = new StringBuffer();
        int counter = 0;
        if (cmdline.hasOption("s")) {
            counter = Integer.parseInt(cmdline.getOptionValue('s')) - 1;
        }
        int end = Integer.MAX_VALUE;
        if (cmdline.hasOption("e")) {
            end = Integer.parseInt(cmdline.getOptionValue('e'));
        }
        while (counter < end) {
            Attributes attrs = this.generateLdif(++counter);
            dnBuf.setLength(0);
            dnBuf.append("uid=user.").append(counter).append(",").append(this.baseDn);
            long startTime = System.currentTimeMillis();
            ctx.createSubcontext(dnBuf.toString(), attrs);
            outBuf.setLength(0);
            outBuf.append(counter).append(" ").append(System.currentTimeMillis() - startTime);
            out.println(outBuf.toString());
            out.flush();
        }
    }

    private boolean createBase(LdapContext ctx) throws NamingException {
        BasicAttributes attrs = new BasicAttributes("objectClass", "organizationalUnit", true);
        attrs.put("ou", "users");
        try {
            ctx.createSubcontext("ou=users,dc=example,dc=com", (Attributes)attrs);
            return true;
        }
        catch (NameAlreadyBoundException e) {
            return false;
        }
    }

    private Attributes generateLdif(int counter) {
        BasicAttributes attrs = new BasicAttributes("objectClass", "top", true);
        Attribute oc = attrs.get("objectClass");
        oc.add("person");
        oc.add("organizationalPerson");
        oc.add("inetOrgPerson");
        attrs.put("givenName", RandomStringUtils.randomAlphabetic((int)6));
        attrs.put("sn", RandomStringUtils.randomAlphabetic((int)9));
        attrs.put("cn", RandomStringUtils.randomAlphabetic((int)15));
        attrs.put("initials", RandomStringUtils.randomAlphabetic((int)2));
        attrs.put("mail", RandomStringUtils.randomAlphabetic((int)15));
        attrs.put("userPassword", "password");
        attrs.put("telephoneNumber", RandomStringUtils.randomNumeric((int)10));
        attrs.put("homePhone", RandomStringUtils.randomNumeric((int)10));
        attrs.put("pager", RandomStringUtils.randomNumeric((int)10));
        attrs.put("mobile", RandomStringUtils.randomNumeric((int)10));
        attrs.put("employeeNumber", String.valueOf(counter));
        attrs.put("street", RandomStringUtils.randomAlphabetic((int)20));
        attrs.put("l", RandomStringUtils.randomAlphabetic((int)10));
        attrs.put("st", RandomStringUtils.randomAlphabetic((int)2));
        attrs.put("postalCode", RandomStringUtils.randomAlphabetic((int)5));
        attrs.put("postalAddress", RandomStringUtils.randomAlphabetic((int)20));
        attrs.put("description", RandomStringUtils.randomAlphabetic((int)20));
        return attrs;
    }

    private void processOptions(CommandLine cmd) {
        if (this.isDebugEnabled()) {
            System.out.println("Processing options for capacity test ...");
        }
        if (cmd.hasOption('p')) {
            String val = cmd.getOptionValue('p');
            try {
                this.port = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("port value of '" + val + "' is not a number");
                System.exit(1);
            }
            if (this.port > 49151) {
                System.err.println("port value of '" + val + "' is larger than max port number: " + 49151);
                System.exit(1);
            } else if (this.port < 1) {
                System.err.println("port value of '" + val + "' is smaller than the minimum port number: " + 1);
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by -p option: " + this.port);
            }
        } else if (this.getApacheDS() != null) {
            this.port = this.getApacheDS().getLdapServer().getPort();
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by server.xml configuration: " + this.port);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("port set to default: " + this.port);
        }
        if (cmd.hasOption('h')) {
            this.host = cmd.getOptionValue('h');
            if (this.isDebugEnabled()) {
                System.out.println("host overriden by -h option: " + this.host);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("host set to default: " + this.host);
        }
        if (cmd.hasOption('w')) {
            this.password = cmd.getOptionValue('w');
            if (this.isDebugEnabled()) {
                System.out.println("password overriden by -w option: " + this.password);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("password set to default: " + this.password);
        }
    }

    public Options getOptions() {
        Options opts = new Options();
        Option op = new Option("f", "file", true, "file to output the stats to");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("i", "install-path", true, "path to apacheds installation directory");
        op.setRequired(true);
        opts.addOption(op);
        op = new Option("h", "host", true, "server host: defaults to localhost");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("p", "port", true, "server port: defaults to 10389 or server.xml specified port");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("w", "password", true, "the apacheds administrator's password: defaults to secret");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("s", "start", true, "start on id: number to start on (user.start)");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("e", "end", true, "end on id: number to end on (user.end)");
        op.setRequired(false);
        opts.addOption(op);
        return opts;
    }
}

