/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.util.Hashtable;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.directory.server.tools.ToolCommand;
import org.apache.directory.shared.ldap.message.extended.LaunchDiagnosticUiRequest;

public class DiagnosticCommand
extends ToolCommand {
    public static final String PORT_RANGE = "(1, 49151)";
    private int port = 10389;
    private String host = "localhost";
    private String password = "secret";

    protected DiagnosticCommand() {
        super("diagnostic");
    }

    public void execute(CommandLine cmd) throws Exception {
        this.processOptions(cmd);
        if (this.isDebugEnabled()) {
            System.out.println("Parameters for LaunchDiagnosticUI extended request:");
            System.out.println("port = " + this.port);
            System.out.println("host = " + this.host);
            System.out.println("password = " + this.password);
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + this.host + ":" + this.port);
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", this.password);
        env.put("java.naming.security.authentication", "simple");
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        if (this.isDebugEnabled()) {
            System.out.println("Connection to the server established.\nSending extended request ... ");
        }
        ctx.extendedOperation((ExtendedRequest)new LaunchDiagnosticUiRequest(3));
        ctx.close();
    }

    private void processOptions(CommandLine cmd) {
        if (this.isDebugEnabled()) {
            System.out.println("Processing options for launching diagnostic UI ...");
        }
        if (cmd.hasOption('p')) {
            String val = cmd.getOptionValue('p');
            try {
                this.port = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("port value of '" + val + "' is not a number");
                System.exit(1);
            }
            if (this.port > 49151) {
                System.err.println("port value of '" + val + "' is larger than max port number: " + 49151);
                System.exit(1);
            } else if (this.port < 1) {
                System.err.println("port value of '" + val + "' is smaller than the minimum port number: " + 1);
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by -p option: " + this.port);
            }
        } else if (this.getApacheDS() != null) {
            this.port = this.getApacheDS().getLdapServer().getPort();
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by server.xml configuration: " + this.port);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("port set to default: " + this.port);
        }
        if (cmd.hasOption('h')) {
            this.host = cmd.getOptionValue('h');
            if (this.isDebugEnabled()) {
                System.out.println("host overriden by -h option: " + this.host);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("host set to default: " + this.host);
        }
        if (cmd.hasOption('w')) {
            this.password = cmd.getOptionValue('w');
            if (this.isDebugEnabled()) {
                System.out.println("password overriden by -w option: " + this.password);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("password set to default: " + this.password);
        }
    }

    public Options getOptions() {
        Options opts = new Options();
        Option op = new Option("h", "host", true, "server host: defaults to localhost");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("p", "port", true, "server port: defaults to 10389 or server.xml specified port");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("w", "password", true, "the apacheds administrator's password: defaults to secret");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("i", "install-path", true, "path to apacheds installation directory");
        op.setRequired(false);
        opts.addOption(op);
        return opts;
    }
}

