/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.util.Hashtable;
import javax.naming.event.EventContext;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.UnsolicitedNotification;
import javax.naming.ldap.UnsolicitedNotificationEvent;
import javax.naming.ldap.UnsolicitedNotificationListener;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.directory.server.tools.ToolCommand;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.message.extended.GracefulDisconnect;

public class DisconnectNotificationCommand
extends ToolCommand
implements UnsolicitedNotificationListener {
    UnsolicitedNotification notification;
    boolean canceled = false;
    private String host = "localhost";
    private int port = 10389;
    private String bindDn = "uid=admin,ou=system";
    private String password = "secret";

    protected DisconnectNotificationCommand() {
        super("notifications");
    }

    public void notificationReceived(UnsolicitedNotificationEvent evt) {
        this.notification = evt.getNotification();
        if (this.notification.getID().equals("1.3.6.1.4.1.1466.20036")) {
            System.out.println("\nRecieved NoticeOfDisconnect: 1.3.6.1.4.1.1466.20036");
            System.out.println("Expect to loose this connection without further information.");
            this.canceled = true;
        } else if (this.notification.getID().equals("1.3.6.1.4.1.18060.0.1.5")) {
            System.out.println("Recieved GracefulDisconnect: 1.3.6.1.4.1.18060.0.1.5");
            GracefulDisconnect gd = null;
            try {
                gd = new GracefulDisconnect(this.notification.getEncodedValue());
            }
            catch (DecoderException de) {
                de.printStackTrace();
            }
            System.out.println("LDAP server will shutdown in " + gd.getDelay() + " seconds.");
            System.out.println("LDAP server will be back online in " + gd.getTimeOffline() + " minutes.");
            if (gd.getDelay() > 0) {
                Thread t = new Thread(new Counter(gd.getDelay()));
                t.start();
            }
        } else {
            System.out.println("Unknown event recieved with OID: " + evt.getNotification().getID());
        }
    }

    public void namingExceptionThrown(NamingExceptionEvent evt) {
        this.canceled = true;
        System.out.println("Got an excption event: " + evt.getException().getMessage());
        System.out.println("Process shutting down abruptly.");
        System.exit(1);
    }

    public void execute(CommandLine cmd) throws Exception {
        this.processOptions(cmd);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + this.host + ":" + this.port);
        env.put("java.naming.security.principal", this.bindDn);
        env.put("java.naming.security.credentials", this.password);
        env.put("java.naming.security.authentication", "simple");
        LdapContext ctx = new InitialLdapContext(env, null);
        ctx = ctx.newInstance(null);
        DisconnectNotificationCommand listener = new DisconnectNotificationCommand();
        ((EventContext)((Object)ctx)).addNamingListener("", 2, (NamingListener)listener);
        System.out.println("Listening for notifications.");
        System.out.println("Press any key to terminate.");
        System.in.read();
        ctx.close();
        System.out.println("Process terminated!!!");
    }

    private void processOptions(CommandLine cmd) {
        if (this.isDebugEnabled()) {
            System.out.println("Processing options for disconnect notifications ...");
        }
        if (cmd.hasOption('p')) {
            String val = cmd.getOptionValue('p');
            try {
                this.port = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("port value of '" + val + "' is not a number");
                System.exit(1);
            }
            if (this.port > 49151) {
                System.err.println("port value of '" + val + "' is larger than max port number: " + 49151);
                System.exit(1);
            } else if (this.port < 1) {
                System.err.println("port value of '" + val + "' is smaller than the minimum port number: " + 1);
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by -p option: " + this.port);
            }
        } else if (this.getApacheDS() != null) {
            this.port = this.getApacheDS().getLdapServer().getPort();
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by server.xml configuration: " + this.port);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("port set to default: " + this.port);
        }
        if (cmd.hasOption('h')) {
            this.host = cmd.getOptionValue('h');
            if (this.isDebugEnabled()) {
                System.out.println("host overriden by -h option: " + this.host);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("host set to default: " + this.host);
        }
        if (cmd.hasOption('w')) {
            this.password = cmd.getOptionValue('w');
            if (this.isDebugEnabled()) {
                System.out.println("password overriden by -w option: " + this.password);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("password set to default: " + this.password);
        }
        if (cmd.hasOption('u')) {
            this.bindDn = cmd.getOptionValue('u');
            if (this.isDebugEnabled()) {
                System.out.println("binddn overriden by -u option: " + this.bindDn);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("binddn set to default: " + this.bindDn);
        }
    }

    public Options getOptions() {
        Options opts = new Options();
        Option op = new Option("h", "host", true, "server host: defaults to localhost");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("p", "port", true, "server port: defaults to 10389 or server.xml specified port");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("w", "password", true, "the apacheds administrator's password: defaults to secret");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("u", "binddn", true, "an apacheds user's dn: defaults to " + this.bindDn);
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("i", "install-path", true, "path to apacheds installation directory");
        op.setRequired(false);
        opts.addOption(op);
        return opts;
    }

    class Counter
    implements Runnable {
        int delay;

        Counter(int delay) {
            this.delay = delay;
        }

        public void run() {
            System.out.println("Starting countdown until server shutdown:");
            System.out.print("[");
            long delayMillis = this.delay * 1000 - 1000;
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < delayMillis && !DisconnectNotificationCommand.this.canceled) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                System.out.print(".");
            }
            if (DisconnectNotificationCommand.this.canceled) {
                System.out.println(" -- countdown canceled -- ");
            } else {
                System.out.println("]");
                System.out.println("Client shutting down gracefully.");
                System.exit(0);
            }
        }
    }
}

