/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.schema.SerializableComparator;
import org.apache.directory.server.schema.bootstrap.ApacheSchema;
import org.apache.directory.server.schema.bootstrap.ApachemetaSchema;
import org.apache.directory.server.schema.bootstrap.BootstrapSchemaLoader;
import org.apache.directory.server.schema.bootstrap.CoreSchema;
import org.apache.directory.server.schema.bootstrap.SystemSchema;
import org.apache.directory.server.schema.bootstrap.partition.DbFileListing;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.server.schema.registries.DefaultOidRegistry;
import org.apache.directory.server.schema.registries.DefaultRegistries;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SchemaLoader;
import org.apache.directory.server.tools.ToolCommand;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.MultiException;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.Base64;

public class DumpCommand
extends ToolCommand {
    private Registries bootstrapRegistries = new DefaultRegistries("bootstrap", (SchemaLoader)new BootstrapSchemaLoader(), (OidRegistry)new DefaultOidRegistry());
    private Set<String> exclusions = new HashSet<String>();
    private boolean includeOperational = false;

    public DumpCommand() {
        super("dump");
    }

    private Registries loadRegistries() throws Exception {
        DbFileListing listing;
        BootstrapSchemaLoader loader = new BootstrapSchemaLoader();
        DefaultOidRegistry oidRegistry = new DefaultOidRegistry();
        DefaultRegistries registries = new DefaultRegistries("bootstrap", (SchemaLoader)loader, (OidRegistry)oidRegistry);
        HashSet<Object> bootstrapSchemas = new HashSet<Object>();
        bootstrapSchemas.add(new ApachemetaSchema());
        bootstrapSchemas.add(new ApacheSchema());
        bootstrapSchemas.add(new CoreSchema());
        bootstrapSchemas.add(new SystemSchema());
        loader.loadWithDependencies(bootstrapSchemas, (Registries)registries);
        List errors = registries.checkRefInteg();
        if (!errors.isEmpty()) {
            MultiException e = new MultiException();
            for (Throwable t : errors) {
                e.addThrowable(t);
            }
            throw e;
        }
        SerializableComparator.setRegistry((ComparatorRegistry)registries.getComparatorRegistry());
        File schemaDirectory = new File(this.getLayout().getPartitionsDirectory(), "schema");
        if (!schemaDirectory.exists()) {
            throw new LdapConfigurationException("The following schema directory from the installation layout could not be found:\n\t" + schemaDirectory);
        }
        JdbmPartition schemaPartition = new JdbmPartition();
        schemaPartition.setId("schema");
        schemaPartition.setCacheSize(1000);
        try {
            listing = new DbFileListing();
        }
        catch (IOException e) {
            throw new LdapNamingException("Got IOException while trying to read DBFileListing: " + e.getMessage(), ResultCodeEnum.OTHER);
        }
        HashSet<JdbmIndex> indexedAttributes = new HashSet<JdbmIndex>();
        for (String attributeId : listing.getIndexedAttributes()) {
            indexedAttributes.add(new JdbmIndex(attributeId));
        }
        schemaPartition.setIndexedAttributes(indexedAttributes);
        schemaPartition.setSuffix("ou=schema");
        DefaultDirectoryService directoryService = new DefaultDirectoryService();
        schemaPartition.init((DirectoryService)directoryService);
        PartitionSchemaLoader schemaLoader = new PartitionSchemaLoader((Partition)schemaPartition, (Registries)registries);
        DefaultRegistries globalRegistries = new DefaultRegistries("global", (SchemaLoader)schemaLoader, (OidRegistry)oidRegistry);
        schemaLoader.loadEnabled((Registries)globalRegistries);
        SerializableComparator.setRegistry((ComparatorRegistry)globalRegistries.getComparatorRegistry());
        return globalRegistries;
    }

    public void execute(CommandLine cmdline) throws Exception {
        this.getLayout().verifyInstallation();
        this.bootstrapRegistries = this.loadRegistries();
        this.includeOperational = cmdline.hasOption('o');
        String[] partitions = cmdline.getOptionValues('p');
        String outputFile = cmdline.getOptionValue('f');
        PrintWriter out = null;
        String[] excludedAttributes = cmdline.getOptionValues('e');
        if (excludedAttributes != null) {
            AttributeTypeRegistry registry = this.bootstrapRegistries.getAttributeTypeRegistry();
            for (String attributeType : excludedAttributes) {
                AttributeType type = registry.lookup(attributeType);
                this.exclusions.add(type.getName());
            }
        }
        out = outputFile == null ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(outputFile));
        for (String partition : partitions) {
            File partitionDirectory = new File(this.getLayout().getPartitionsDirectory(), partition);
            out.println("\n\n");
            this.dump(partitionDirectory, out);
        }
    }

    private void dump(File partitionDirectory, PrintWriter out) throws Exception {
        if (!partitionDirectory.exists()) {
            System.err.println("Partition directory " + partitionDirectory + " does not exist!");
            System.exit(1);
        }
        out.println("# ========================================================================");
        out.println("# ApacheDS Tools Version: " + this.getVersion());
        out.println("# Partition Directory: " + partitionDirectory);
        out.println("# ========================================================================\n\n");
        String path = partitionDirectory.getPath() + File.separator + "master";
        BaseRecordManager base = new BaseRecordManager(path);
        base.disableTransactions();
        CacheRecordManager recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(1000));
        JdbmMasterTable master = new JdbmMasterTable((RecordManager)recMan, this.bootstrapRegistries);
        AttributeType attributeType = this.bootstrapRegistries.getAttributeTypeRegistry().lookup("apacheUpdn");
        JdbmIndex idIndex = new JdbmIndex();
        idIndex.setAttributeId(attributeType.getName());
        idIndex.setWkDirPath(partitionDirectory);
        idIndex.setCacheSize(1000);
        idIndex.setNumDupLimit(1000);
        idIndex.init(attributeType, partitionDirectory);
        out.println("#---------------------");
        Cursor list = master.cursor();
        StringBuffer buf = new StringBuffer();
        while (list.next()) {
            Tuple tuple = (Tuple)list.get();
            Long id = (Long)tuple.getKey();
            String dn = (String)idIndex.reverseLookup(id);
            Attributes entry = (Attributes)tuple.getValue();
            this.filterAttributes(dn, entry);
            buf.append("# Entry: ").append(id).append("\n#---------------------\n\n");
            if (!LdifUtils.isLDIFSafe((String)dn)) {
                buf.append("dn:: ").append(new String(Base64.encode((byte[])dn.getBytes())));
            } else {
                buf.append("dn: ").append(dn);
            }
            buf.append("\n").append(LdifUtils.convertToLdif((Attributes)entry));
            if (list.next()) {
                buf.append("\n\n#---------------------\n");
            }
            out.print(buf.toString());
            out.flush();
            buf.setLength(0);
        }
    }

    private void filterAttributes(String dn, Attributes entry) throws Exception {
        ArrayList<String> toRemove = new ArrayList<String>();
        AttributeTypeRegistry registry = this.bootstrapRegistries.getAttributeTypeRegistry();
        NamingEnumeration<? extends Attribute> attrs = entry.getAll();
        while (attrs.hasMore()) {
            boolean isOperational;
            Attribute attr = attrs.next();
            if (!registry.hasAttributeType(attr.getID())) {
                if (this.isQuietEnabled()) continue;
                System.out.println("# Cannot properly filter unrecognized attribute " + attr.getID() + " in " + dn);
                continue;
            }
            AttributeType type = registry.lookup(attr.getID());
            boolean bl = isOperational = type.getUsage() != UsageEnum.USER_APPLICATIONS;
            if (!this.exclusions.contains(attr.getID()) && (!isOperational || this.includeOperational)) continue;
            toRemove.add(attr.getID());
        }
        for (String id : toRemove) {
            entry.remove(id);
            if (!this.isDebugEnabled()) continue;
            System.out.println("# Excluding attribute " + id + " in " + dn);
        }
    }

    public Options getOptions() {
        Options opts = new Options();
        Option op = new Option("f", "file", true, "file to output the dump to");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("p", "partitions", true, "the partitions to dump");
        op.setRequired(true);
        op.setValueSeparator(File.pathSeparatorChar);
        opts.addOption(op);
        op = new Option("e", "excluded-attributes", true, "the attributes to exclude");
        op.setRequired(false);
        op.setValueSeparator(File.pathSeparatorChar);
        opts.addOption(op);
        op = new Option("o", "include-operational", false, "include operational attributes: defaults to false");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("i", "install-path", true, "path to apacheds installation directory");
        op.setRequired(true);
        opts.addOption(op);
        return opts;
    }
}

