/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.directory.server.tools.ToolCommand;
import org.apache.directory.shared.ldap.message.extended.GracefulShutdownRequest;

public class GracefulShutdownCommand
extends ToolCommand {
    public static final String PORT_RANGE = "(1, 49151)";
    private static final int DELAY_MAX = 86400;
    private static final int TIME_OFFLINE_MAX = 720;
    private int port = 10389;
    private String host = "localhost";
    private String password = "secret";
    private int delay;
    private int timeOffline;
    private boolean isWaiting;
    private boolean isSuccess = false;
    private Thread executeThread = null;

    protected GracefulShutdownCommand() {
        super("graceful");
    }

    public void execute(CommandLine cmd) throws Exception {
        this.executeThread = Thread.currentThread();
        this.processOptions(cmd);
        if (this.isDebugEnabled()) {
            System.out.println("Parameters for GracefulShutdown extended request:");
            System.out.println("port = " + this.port);
            System.out.println("host = " + this.host);
            System.out.println("password = " + this.password);
            System.out.println("delay = " + this.delay);
            System.out.println("timeOffline = " + this.timeOffline);
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + this.host + ":" + this.port);
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", this.password);
        env.put("java.naming.security.authentication", "simple");
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        if (!this.isQuietEnabled()) {
            System.out.println("Connection to the server established.\nSending extended request and blocking for shutdown:");
            this.isWaiting = true;
            Thread t = new Thread(new Ticker());
            t.start();
        }
        try {
            ctx.extendedOperation((ExtendedRequest)new GracefulShutdownRequest(0, this.timeOffline, this.delay));
            this.isSuccess = true;
        }
        catch (Throwable t) {
            try {
                new InitialLdapContext(env, null);
                this.isSuccess = false;
                System.err.print("shutdown request failed with error: " + t.getMessage());
            }
            catch (CommunicationException e) {
                this.isSuccess = true;
            }
        }
        this.isWaiting = false;
        ctx.close();
    }

    private void processOptions(CommandLine cmd) {
        String val;
        if (this.isDebugEnabled()) {
            System.out.println("Processing options for graceful shutdown ...");
        }
        if (cmd.hasOption('p')) {
            val = cmd.getOptionValue('p');
            try {
                this.port = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("port value of '" + val + "' is not a number");
                System.exit(1);
            }
            if (this.port > 49151) {
                System.err.println("port value of '" + val + "' is larger than max port number: " + 49151);
                System.exit(1);
            } else if (this.port < 1) {
                System.err.println("port value of '" + val + "' is smaller than the minimum port number: " + 1);
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by -p option: " + this.port);
            }
        } else if (this.getApacheDS() != null) {
            this.port = this.getApacheDS().getLdapServer().getPort();
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by server.xml configuration: " + this.port);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("port set to default: " + this.port);
        }
        if (cmd.hasOption('h')) {
            this.host = cmd.getOptionValue('h');
            if (this.isDebugEnabled()) {
                System.out.println("host overriden by -h option: " + this.host);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("host set to default: " + this.host);
        }
        if (cmd.hasOption('w')) {
            this.password = cmd.getOptionValue('w');
            if (this.isDebugEnabled()) {
                System.out.println("password overriden by -w option: " + this.password);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("password set to default: " + this.password);
        }
        if (cmd.hasOption('e')) {
            val = cmd.getOptionValue('e');
            try {
                this.delay = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("delay value of '" + val + "' is not a number");
                System.exit(1);
            }
            if (this.delay > 86400) {
                System.err.println("delay value of '" + val + "' is larger than max delay (seconds) allowed: " + 86400);
                System.exit(1);
            } else if (this.delay < 0) {
                System.err.println("delay value of '" + val + "' is less than zero and makes no sense");
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                System.out.println("delay seconds overriden by -e option: " + this.delay);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("Using default delay value of " + this.delay);
        }
        if (cmd.hasOption('t')) {
            val = cmd.getOptionValue('t');
            try {
                this.timeOffline = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("timeOffline value of '" + val + "' is not a number");
                System.exit(1);
            }
            if (this.timeOffline > 720) {
                System.err.println("timeOffline value of '" + val + "' is larger than max timeOffline (minutes) allowed: " + 720);
                System.exit(1);
            } else if (this.timeOffline < 0) {
                System.err.println("timeOffline value of '" + val + "' is less than zero and makes no sense");
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                System.out.println("timeOffline seconds overriden by -t option: " + this.timeOffline);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("Using default timeOffline value of " + this.delay);
        }
    }

    public Options getOptions() {
        Options opts = new Options();
        Option op = new Option("h", "host", true, "server host: defaults to localhost");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("p", "port", true, "server port: defaults to 10389 or server.xml specified port");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("e", "delay", true, "delay (seconds) before shutdown: defaults to 0");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("w", "password", true, "the apacheds administrator's password: defaults to secret");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("t", "time-offline", true, "server offline time (minutes): defaults to 0 (indefinate)");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("i", "install-path", true, "path to apacheds installation directory");
        op.setRequired(false);
        opts.addOption(op);
        return opts;
    }

    class Ticker
    implements Runnable {
        Ticker() {
        }

        public void run() {
            if (!GracefulShutdownCommand.this.isQuietEnabled()) {
                System.out.print("[waiting for shutdown] ");
            }
            while (GracefulShutdownCommand.this.isWaiting) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (GracefulShutdownCommand.this.isQuietEnabled()) continue;
                System.out.print(".");
            }
            if (GracefulShutdownCommand.this.isSuccess) {
                if (!GracefulShutdownCommand.this.isQuietEnabled()) {
                    System.out.println("\n[shutdown complete]");
                }
                try {
                    GracefulShutdownCommand.this.executeThread.join(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.exit(0);
            } else {
                if (!GracefulShutdownCommand.this.isQuietEnabled()) {
                    System.out.println("\n[shutdown failed]");
                }
                try {
                    GracefulShutdownCommand.this.executeThread.join(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
        }
    }
}

