/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.directory.server.tools.ToolCommand;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapDecoder;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.del.DelRequestCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestCodec;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequestCodec;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.StringTools;

public class ImportCommand
extends ToolCommand {
    public static final String PORT_RANGE = "(1, 49151)";
    private int port = 10389;
    private String host = "localhost";
    private String password = "secret";
    private String user = "uid=admin,ou=system";
    private String auth = "simple";
    private File ldifFile;
    private String logs;
    private boolean ignoreErrors = false;
    private static final int IMPORT_ERROR = -1;
    private static final int IMPORT_SUCCESS = 0;
    private SocketChannel channel;
    private SocketAddress serverAddress;
    private IAsn1Container ldapMessageContainer = new LdapMessageContainer();
    private Asn1Decoder ldapDecoder = new LdapDecoder();

    protected ImportCommand() {
        super("import");
    }

    private void connect() throws UnknownHostException, IOException {
        this.serverAddress = new InetSocketAddress(this.host, this.port);
        this.channel = SocketChannel.open(this.serverAddress);
        this.channel.configureBlocking(true);
    }

    private void sendMessage(ByteBuffer bb) throws IOException {
        this.channel.write(bb);
        bb.clear();
    }

    private LdapMessageCodec readResponse(ByteBuffer bb) throws IOException, DecoderException, NamingException {
        int nbRead;
        LdapMessageCodec messageResp = null;
        while ((nbRead = this.channel.read(bb)) != -1) {
            bb.flip();
            this.ldapDecoder.decode(bb, this.ldapMessageContainer);
            if (this.ldapMessageContainer.getState() == 1024) {
                ExtendedResponseCodec resp;
                messageResp = ((LdapMessageContainer)this.ldapMessageContainer).getLdapMessage();
                if (messageResp instanceof BindResponseCodec) {
                    BindResponseCodec resp2 = ((LdapMessageContainer)this.ldapMessageContainer).getLdapMessage().getBindResponse();
                    if (resp2.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
                        System.out.println("Error : " + resp2.getLdapResult().getErrorMessage());
                    }
                } else if (messageResp instanceof ExtendedResponseCodec && (resp = ((LdapMessageContainer)this.ldapMessageContainer).getLdapMessage().getExtendedResponse()).getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
                    System.out.println("Error : " + resp.getLdapResult().getErrorMessage());
                }
                ((LdapMessageContainer)this.ldapMessageContainer).clean();
                break;
            }
            bb.flip();
        }
        return messageResp;
    }

    private int addEntry(LdifEntry ldifEntry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        AddRequestCodec addRequest = new AddRequestCodec();
        String dn = ldifEntry.getDn().getUpName();
        if (this.isDebugEnabled()) {
            System.out.println("Adding entry " + dn);
        }
        Entry entry = ldifEntry.getEntry();
        addRequest.setEntryDn(new LdapDN(dn));
        for (EntryAttribute attribute : entry) {
            addRequest.addAttributeType(attribute.getId());
            for (Value value : attribute) {
                addRequest.addAttributeValue(value);
            }
        }
        LdapMessageCodec message = new LdapMessageCodec();
        message.setProtocolOP((Asn1Object)addRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        bb.clear();
        LdapMessageCodec response = this.readResponse(bb);
        LdapResultCodec result = response.getAddResponse().getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            if (this.isDebugEnabled()) {
                System.out.println("Add of Entry " + entry.getDn() + " was successful");
            }
            return 0;
        }
        System.err.println("Add of entry " + entry.getDn() + " failed for the following reasons provided by the server:\n" + result.getErrorMessage());
        return -1;
    }

    private int deleteEntry(LdifEntry entry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        DelRequestCodec delRequest = new DelRequestCodec();
        String dn = entry.getDn().getUpName();
        if (this.isDebugEnabled()) {
            System.out.println("Deleting entry " + dn);
        }
        delRequest.setEntry(new LdapDN(dn));
        LdapMessageCodec message = new LdapMessageCodec();
        message.setProtocolOP((Asn1Object)delRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        bb.clear();
        LdapMessageCodec response = this.readResponse(bb);
        LdapResultCodec result = response.getDelResponse().getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            if (this.isDebugEnabled()) {
                System.out.println("Delete of Entry " + entry.getDn() + " was successful");
            }
            return 0;
        }
        System.err.println("Delete of entry " + entry.getDn() + " failed for the following reasons provided by the server:\n" + result.getErrorMessage());
        return -1;
    }

    private int changeModRDNEntry(LdifEntry entry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        ModifyDNRequestCodec modifyDNRequest = new ModifyDNRequestCodec();
        String dn = entry.getDn().getUpName();
        if (this.isDebugEnabled()) {
            System.out.println("Modify DN of entry " + dn);
        }
        modifyDNRequest.setEntry(new LdapDN(dn));
        modifyDNRequest.setDeleteOldRDN(entry.isDeleteOldRdn());
        modifyDNRequest.setNewRDN(new Rdn(entry.getNewRdn()));
        if (!StringTools.isEmpty((String)entry.getNewSuperior())) {
            modifyDNRequest.setNewSuperior(new LdapDN(entry.getNewSuperior()));
        }
        LdapMessageCodec message = new LdapMessageCodec();
        message.setProtocolOP((Asn1Object)modifyDNRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        bb.clear();
        LdapMessageCodec response = this.readResponse(bb);
        LdapResultCodec result = response.getModifyDNResponse().getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            if (this.isDebugEnabled()) {
                System.out.println("ModifyDn of Entry " + entry.getDn() + " was successful");
            }
            return 0;
        }
        System.err.println("ModifyDn of entry " + entry.getDn() + " failed for the following reasons provided by the server:\n" + result.getErrorMessage());
        return -1;
    }

    private int changeModifyEntry(LdifEntry entry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        ModifyRequestCodec modifyRequest = new ModifyRequestCodec();
        String dn = entry.getDn().getUpName();
        if (this.isDebugEnabled()) {
            System.out.println("Modify of entry " + dn);
        }
        modifyRequest.setObject(new LdapDN(dn));
        modifyRequest.initModifications();
        for (Modification modification : entry.getModificationItems()) {
            modifyRequest.setCurrentOperation(modification.getOperation());
            modifyRequest.addAttributeTypeAndValues(modification.getAttribute().getId());
            for (Value value : modification.getAttribute()) {
                modifyRequest.addAttributeValue(value);
            }
        }
        LdapMessageCodec message = new LdapMessageCodec();
        message.setProtocolOP((Asn1Object)modifyRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        bb.clear();
        LdapMessageCodec response = this.readResponse(bb);
        LdapResultCodec result = response.getModifyResponse().getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            if (this.isDebugEnabled()) {
                System.out.println("Modify of Entry " + entry.getDn() + " was successful");
            }
            return 0;
        }
        System.err.println("Modify of entry " + entry.getDn() + " failed for the following reasons provided by the server:\n" + result.getErrorMessage());
        return -1;
    }

    private int changeEntry(LdifEntry entry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        switch (entry.getChangeType().getChangeType()) {
            case 0: {
                return this.addEntry(entry, messageId);
            }
            case 4: {
                return this.deleteEntry(entry, messageId);
            }
            case 1: {
                return this.changeModifyEntry(entry, messageId);
            }
            case 2: 
            case 3: {
                return this.changeModRDNEntry(entry, messageId);
            }
        }
        return -1;
    }

    private void bind(int messageId) throws NamingException, EncoderException, DecoderException, IOException {
        BindRequestCodec bindRequest = new BindRequestCodec();
        LdapMessageCodec message = new LdapMessageCodec();
        SimpleAuthentication authentication = null;
        if ("simple".equals(this.auth)) {
            authentication = new SimpleAuthentication();
            authentication.setSimple(StringTools.getBytesUtf8((String)this.password));
        }
        bindRequest.setAuthentication(authentication);
        bindRequest.setName(new LdapDN(this.user));
        bindRequest.setVersion(3);
        message.setProtocolOP((Asn1Object)bindRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.connect();
        this.sendMessage(bb);
        bb.clear();
        LdapMessageCodec response = this.readResponse(bb);
        LdapResultCodec result = response.getBindResponse().getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            if (this.isDebugEnabled()) {
                System.out.println("Binding of user " + this.user + " was successful");
            }
        } else {
            System.err.println("Binding of user " + this.user + " failed for the following reasons provided by the server:\n" + result.getErrorMessage());
            System.exit(1);
        }
    }

    private void unbind(int messageId) throws InvalidNameException, EncoderException, DecoderException, IOException {
        UnBindRequestCodec unbindRequest = new UnBindRequestCodec();
        LdapMessageCodec message = new LdapMessageCodec();
        message.setProtocolOP((Asn1Object)unbindRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        if (this.isDebugEnabled()) {
            System.out.println("Unbinding of user " + this.user + " was successful");
        }
    }

    public void execute(CommandLine cmd) throws Exception {
        LdifReader ldifReader;
        this.processOptions(cmd);
        if (this.isDebugEnabled()) {
            System.out.println("Parameters for Ldif import request:");
            System.out.println("port = " + this.port);
            System.out.println("host = " + this.host);
            System.out.println("user = " + this.user);
            System.out.println("auth type = " + this.auth);
            System.out.println("file = " + this.ldifFile);
            System.out.println("logs = " + this.logs);
        }
        int messageId = 0;
        this.bind(messageId++);
        if (this.isDebugEnabled()) {
            System.out.println("Connection to the server established.\nImporting data ... ");
        }
        if ((ldifReader = new LdifReader(this.ldifFile)).containsEntries()) {
            long t0 = System.currentTimeMillis();
            int nbAdd = 0;
            for (LdifEntry entry : ldifReader) {
                if (ldifReader.hasError()) {
                    System.err.println("Found an error while persing an entry : " + ldifReader.getError().getMessage());
                    if (!this.ignoreErrors) {
                        this.unbind(messageId);
                        System.err.println("Import failed...");
                        System.exit(1);
                    }
                }
                if (this.addEntry(entry, messageId++) == -1 && !this.ignoreErrors) {
                    this.unbind(messageId);
                    System.err.println("Import failed...");
                    System.exit(1);
                }
                if (++nbAdd % 10 == 0) {
                    System.out.print('.');
                }
                if (nbAdd % 500 != 0) continue;
                System.out.println(nbAdd);
            }
            long t1 = System.currentTimeMillis();
            System.out.println("Done!");
            System.out.println(nbAdd + " entries added in " + (t1 - t0) / 1000L + " seconds");
        } else {
            long t0 = System.currentTimeMillis();
            int nbMod = 0;
            for (LdifEntry entry : ldifReader) {
                if (ldifReader.hasError()) {
                    System.err.println("Found an error while persing an entry : " + ldifReader.getError().getMessage());
                    if (!this.ignoreErrors) {
                        this.unbind(messageId);
                        System.err.println("Import failed...");
                        System.exit(1);
                    }
                }
                if (this.changeEntry(entry, messageId++) == -1 && !this.ignoreErrors) {
                    this.unbind(messageId);
                    System.err.println("Import failed...");
                    System.exit(1);
                }
                if (++nbMod % 10 == 0) {
                    System.out.print('.');
                }
                if (nbMod % 500 != 0) continue;
                System.out.println(nbMod);
            }
            long t1 = System.currentTimeMillis();
            System.out.println("Done!");
            System.out.println(nbMod + " entries changed in " + (t1 - t0) / 1000L + " seconds");
        }
        this.unbind(messageId++);
    }

    private void processOptions(CommandLine cmd) {
        if (this.isDebugEnabled()) {
            System.out.println("Processing options for launching diagnostic UI ...");
        }
        if (cmd.hasOption('h')) {
            this.host = cmd.getOptionValue('h');
            if (this.isDebugEnabled()) {
                System.out.println("ignore-errors overriden by -i option: true");
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("ignore-errors set to default: false");
        }
        if (cmd.hasOption('p')) {
            String val = cmd.getOptionValue('p');
            try {
                this.port = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("port value of '" + val + "' is not a number");
                System.exit(1);
            }
            if (this.port > 49151) {
                System.err.println("port value of '" + val + "' is larger than max port number: " + 49151);
                System.exit(1);
            } else if (this.port < 1) {
                System.err.println("port value of '" + val + "' is smaller than the minimum port number: " + 1);
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by -p option: " + this.port);
            }
        } else if (this.getApacheDS() != null) {
            this.port = this.getApacheDS().getLdapServer().getPort();
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by server.xml configuration: " + this.port);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("port set to default: " + this.port);
        }
        if (cmd.hasOption('u')) {
            this.user = cmd.getOptionValue('u');
            if (this.isDebugEnabled()) {
                System.out.println("user overriden by -u option: " + this.user);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("user set to default: " + this.user);
        }
        if (cmd.hasOption('w')) {
            this.password = cmd.getOptionValue('w');
            if (this.isDebugEnabled()) {
                System.out.println("password overriden by -w option: " + this.password);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("password set to default: " + this.password);
        }
        if (cmd.hasOption('a')) {
            this.auth = cmd.getOptionValue('a');
            if (this.isDebugEnabled()) {
                System.out.println("authentication type overriden by -a option: " + this.auth);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("authentication type set to default: " + this.auth);
        }
        if (cmd.hasOption('e')) {
            this.ignoreErrors = true;
            if (this.isDebugEnabled()) {
                System.out.println("authentication type overriden by -a option: " + this.auth);
            }
        } else if (this.isDebugEnabled()) {
            System.out.println("authentication type set to default: " + this.auth);
        }
        if (cmd.hasOption('f')) {
            String ldifFileName = cmd.getOptionValue('f');
            this.ldifFile = new File(ldifFileName);
            if (!this.ldifFile.exists()) {
                System.err.println("ldif file '" + ldifFileName + "' does not exist");
                System.exit(1);
            }
            if (!this.ldifFile.canRead()) {
                System.err.println("ldif file '" + ldifFileName + "' can't be read");
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                try {
                    System.out.println("ldif file to import: " + this.ldifFile.getCanonicalPath());
                }
                catch (IOException ioe) {
                    System.out.println("ldif file to import: " + ldifFileName);
                }
            }
        } else {
            System.err.println("ldif file name must be provided");
            System.exit(1);
        }
    }

    public Options getOptions() {
        Options opts = new Options();
        Option op = new Option("h", "host", true, "server host: defaults to localhost");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("p", "port", true, "server port: defaults to 10389 or server.xml specified port");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("u", "user", true, "the user: default to uid=admin, ou=system");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("w", "password", true, "the apacheds administrator's password: defaults to secret");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("a", "auth", true, "the authentication mode: defaults to 'simple'");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("f", "file", true, "the ldif file to import");
        op.setRequired(true);
        opts.addOption(op);
        op = new Option("e", "ignore", false, "continue to process the file even if errors are encountered ");
        op.setRequired(false);
        opts.addOption(op);
        return opts;
    }
}

