/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.io.File;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.schema.SerializableComparator;
import org.apache.directory.server.schema.bootstrap.BootstrapSchemaLoader;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.server.schema.registries.DefaultOidRegistry;
import org.apache.directory.server.schema.registries.DefaultRegistries;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SchemaLoader;
import org.apache.directory.server.tools.ToolCommand;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.server.xdbm.tools.IndexUtils;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.schema.AttributeType;

public class IndexCommand
extends ToolCommand {
    private Registries bootstrapRegistries = new DefaultRegistries("bootstrap", (SchemaLoader)new BootstrapSchemaLoader(), (OidRegistry)new DefaultOidRegistry());
    private DirectoryService directoryService;

    public IndexCommand() {
        super("index");
    }

    private Registries loadRegistries() throws Exception {
        this.directoryService = new DefaultDirectoryService();
        this.directoryService.setWorkingDirectory(this.getInstanceLayout().getPartitionsDir());
        this.directoryService.startup();
        Registries globalRegistries = this.directoryService.getRegistries();
        SerializableComparator.setRegistry((ComparatorRegistry)globalRegistries.getComparatorRegistry());
        return globalRegistries;
    }

    public void execute(CommandLine cmdline) throws Exception {
        this.bootstrapRegistries = this.loadRegistries();
        String[] partitions = cmdline.getOptionValues('p');
        String attribute = cmdline.getOptionValue('a');
        String indexDirPath = cmdline.getOptionValue('w');
        for (int ii = 0; ii < partitions.length; ++ii) {
            File partitionDirectory = new File(this.getInstanceLayout().getPartitionsDir(), partitions[ii]);
            File indexDir = null;
            if (indexDirPath != null) {
                indexDir = new File(indexDirPath);
            }
            AttributeType attrType = this.bootstrapRegistries.getAttributeTypeRegistry().lookup(attribute);
            System.out.println("building index for attribute type: " + attrType + ", of the partition: " + partitions[ii]);
            if (indexDir != null) {
                System.out.println("The index file location is: " + indexDir.getAbsolutePath());
            }
            this.buildIndex(partitionDirectory, indexDir, attrType);
        }
        this.directoryService.shutdown();
    }

    private void buildIndex(File partitionDirectory, File indexDirectory, AttributeType attributeType) throws Exception {
        if (!partitionDirectory.exists()) {
            System.err.println("Partition directory " + partitionDirectory + " does not exist!");
            System.exit(1);
        }
        String path = partitionDirectory.getPath() + File.separator + "master";
        BaseRecordManager base = new BaseRecordManager(path);
        base.disableTransactions();
        CacheRecordManager recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(1000));
        JdbmMasterTable master = new JdbmMasterTable((RecordManager)recMan, this.bootstrapRegistries);
        JdbmIndex index = new JdbmIndex();
        index.setAttributeId(attributeType.getName());
        index.setCacheSize(100);
        index.setNumDupLimit(512);
        if (indexDirectory == null) {
            indexDirectory = partitionDirectory;
        }
        index.setWkDirPath(indexDirectory);
        index.init(attributeType, indexDirectory);
        IndexUtils.printContents((Index)index);
        JdbmIndex existenceIdx = new JdbmIndex();
        existenceIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.3");
        existenceIdx.setCacheSize(100);
        existenceIdx.setNumDupLimit(512);
        existenceIdx.setWkDirPath(partitionDirectory);
        existenceIdx.init(this.bootstrapRegistries.getAttributeTypeRegistry().lookup("1.3.6.1.4.1.18060.0.4.1.2.3"), partitionDirectory);
        Cursor list = master.cursor();
        while (list.next()) {
            Tuple tuple = (Tuple)list.get();
            Long id = (Long)tuple.getKey();
            DefaultServerEntry entry = (DefaultServerEntry)tuple.getValue();
            EntryAttribute attr = entry.get(attributeType);
            if (attr == null) continue;
            for (int ii = 0; ii < attr.size(); ++ii) {
                index.add(attr.get(ii).get(), id);
            }
            existenceIdx.add((Object)attributeType.getOid(), id);
        }
        index.sync();
        index.close();
        existenceIdx.sync();
        existenceIdx.close();
    }

    public Options getOptions() {
        Options opts = new Options();
        Option op = null;
        op = new Option("p", "partitions", true, "the partitions to add the attribute indices to");
        op.setRequired(true);
        op.setValueSeparator(File.pathSeparatorChar);
        opts.addOption(op);
        op = new Option("a", "attributes", true, "the attribute to index");
        op.setRequired(true);
        op.setValueSeparator(File.pathSeparatorChar);
        opts.addOption(op);
        op = new Option("i", "install-path", true, "path to apacheds installation directory");
        op.setRequired(true);
        opts.addOption(op);
        op = new Option("w", "index-path", true, "path to the directory where index should be stored");
        op.setRequired(false);
        opts.addOption(op);
        return opts;
    }
}

