/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceLayout {
    private final File instanceRoot;
    private FileFilter dirFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public InstanceLayout(File location) {
        this.instanceRoot = location;
    }

    public InstanceLayout(String location) {
        this.instanceRoot = new File(location);
    }

    public File getPartitionsDir() {
        return new File(this.instanceRoot, "partitions");
    }

    public File getLogDir() {
        return new File(this.instanceRoot, "log");
    }

    public File getConfDir() {
        return new File(this.instanceRoot, "conf");
    }

    public List<File> getPartitions() {
        File[] dirs;
        ArrayList<File> partitions = new ArrayList<File>();
        for (File f : dirs = this.getPartitionsDir().listFiles(this.dirFilter)) {
            File masterFile = new File(f, "master.db");
            if (!masterFile.isFile() || !masterFile.exists()) continue;
            partitions.add(f);
        }
        return partitions;
    }
}

