/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.directory.daemon.InstallationLayout;
import org.apache.directory.server.configuration.ApacheDS;
import org.apache.directory.server.tools.InstanceLayout;

public abstract class ToolCommand {
    private final String name;
    private boolean debugEnabled = false;
    private boolean verboseEnabled = false;
    private boolean quietEnabled = false;
    private String version;
    private InstallationLayout layout;
    private ApacheDS apacheDS;
    private InstanceLayout instanceLayout;

    protected ToolCommand(String name) {
        this.name = name;
    }

    public abstract void execute(CommandLine var1) throws Exception;

    public abstract Options getOptions();

    public String getName() {
        return this.name;
    }

    public void setLayout(File installationDirectory) {
        this.layout = new InstallationLayout(installationDirectory);
    }

    public void setLayout(String installationPath) {
        this.layout = new InstallationLayout(installationPath);
    }

    public void setLayout(InstallationLayout layout) {
        this.layout = layout;
    }

    public void setInstanceLayout(InstanceLayout instanceLayout) {
        this.instanceLayout = instanceLayout;
    }

    public InstanceLayout getInstanceLayout() {
        return this.instanceLayout;
    }

    public InstallationLayout getLayout() {
        return this.layout;
    }

    public void setApacheDS(ApacheDS apacheDS) {
        this.apacheDS = apacheDS;
    }

    public ApacheDS getApacheDS() {
        return this.apacheDS;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.getName();
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setVerboseEnabled(boolean verboseEnabled) {
        this.verboseEnabled = verboseEnabled;
    }

    public boolean isVerboseEnabled() {
        return this.verboseEnabled;
    }

    public void setQuietEnabled(boolean quietEnabled) {
        this.quietEnabled = quietEnabled;
    }

    public boolean isQuietEnabled() {
        return this.quietEnabled;
    }
}

