/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.io.IOException;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfHeader {
    private int type;
    private int recordSize;
    private int version;
    private int filesize;
    private int numberOfObjects;
    private long maxRecord;
    private int numberOfMembers;

    public HwmfHeader(LittleEndianInputStream leis) throws IOException {
        this.type = leis.readUShort();
        this.recordSize = leis.readUShort();
        int bytesLeft = this.recordSize * 2 - 4;
        this.version = leis.readUShort();
        bytesLeft -= 2;
        this.filesize = leis.readInt();
        bytesLeft -= 4;
        this.numberOfObjects = leis.readUShort();
        bytesLeft -= 2;
        this.maxRecord = leis.readUInt();
        bytesLeft -= 4;
        this.numberOfMembers = leis.readUShort();
        if ((bytesLeft -= 2) > 0) {
            long len = leis.skip((long)bytesLeft);
            assert (len == (long)bytesLeft);
        }
    }
}

