/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.transaction.impl.lifecycle;

import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.jboss.arquillian.transaction.api.annotation.TransactionMode;
import org.jboss.arquillian.transaction.api.annotation.Transactional;
import org.jboss.arquillian.transaction.impl.configuration.TransactionConfiguration;
import org.jboss.arquillian.transaction.impl.lifecycle.TransactionEnablerLoader;
import org.jboss.arquillian.transaction.impl.test.DefaultTransactionalTest;
import org.jboss.arquillian.transaction.spi.context.TransactionContext;
import org.jboss.arquillian.transaction.spi.event.AfterTransactionEnded;
import org.jboss.arquillian.transaction.spi.event.AfterTransactionStarted;
import org.jboss.arquillian.transaction.spi.event.BeforeTransactionEnded;
import org.jboss.arquillian.transaction.spi.event.BeforeTransactionStarted;
import org.jboss.arquillian.transaction.spi.event.TransactionEvent;
import org.jboss.arquillian.transaction.spi.provider.TransactionEnabler;
import org.jboss.arquillian.transaction.spi.provider.TransactionProvider;
import org.jboss.arquillian.transaction.spi.test.TransactionalTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionHandler {
    @Inject
    private Instance<ServiceLoader> serviceLoaderInstance;
    @Inject
    private Instance<TransactionConfiguration> configurationInstance;
    @Inject
    private Event<TransactionEvent> lifecycleEvent;
    @Inject
    private Instance<TransactionContext> transactionContextInstance;
    @Inject
    private Instance<TestResult> testResultInstance;
    @Inject
    private Instance<TransactionProvider> transactionProviderInstance;

    public abstract boolean isTransactionSupported(TestEvent var1);

    public void startTransactionBeforeTest(@Observes(precedence=10) Before beforeTest) {
        if (this.isTransactionEnabled((TestEvent)beforeTest)) {
            TransactionContext transactionContext = (TransactionContext)this.transactionContextInstance.get();
            transactionContext.activate();
            this.lifecycleEvent.fire((Object)new BeforeTransactionStarted());
            ((TransactionProvider)this.transactionProviderInstance.get()).beginTransaction((TransactionalTest)new DefaultTransactionalTest(this.getTransactionManager((TestEvent)beforeTest)));
            this.lifecycleEvent.fire((Object)new AfterTransactionStarted());
        }
    }

    public void endTransactionAfterTest(@Observes(precedence=-1) EventContext<After> afterTestContext) {
        try {
            afterTestContext.proceed();
        }
        finally {
            this.endTransaction((After)afterTestContext.getEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTransaction(After afterTest) {
        if (this.isTransactionEnabled((TestEvent)afterTest)) {
            try {
                this.lifecycleEvent.fire((Object)new BeforeTransactionEnded());
                TransactionProvider transactionProvider = (TransactionProvider)this.transactionProviderInstance.get();
                DefaultTransactionalTest transactionalTest = new DefaultTransactionalTest(this.getTransactionManager((TestEvent)afterTest));
                if (this.rollbackRequired((TestEvent)afterTest)) {
                    transactionProvider.rollbackTransaction((TransactionalTest)transactionalTest);
                } else {
                    transactionProvider.commitTransaction((TransactionalTest)transactionalTest);
                }
            }
            finally {
                this.lifecycleEvent.fire((Object)new AfterTransactionEnded());
                ((TransactionContext)this.transactionContextInstance.get()).destroy();
            }
        }
    }

    private boolean isTransactionEnabled(TestEvent testEvent) {
        if (!this.isTransactionSupported(testEvent)) {
            return false;
        }
        TransactionMode transactionMode = this.getTransactionMode(testEvent);
        return transactionMode != null && !TransactionMode.DISABLED.equals((Object)transactionMode);
    }

    private boolean rollbackRequired(TestEvent testEvent) {
        return this.testRequiresRollbackDueToFailure() || TransactionMode.ROLLBACK.equals((Object)this.getTransactionMode(testEvent));
    }

    private boolean testRequiresRollbackDueToFailure() {
        if (this.testResultInstance.get() != null) {
            TestResult.Status actualStatus = ((TestResult)this.testResultInstance.get()).getStatus();
            return TestResult.Status.FAILED.equals((Object)actualStatus);
        }
        return true;
    }

    private TransactionMode getTransactionMode(TestEvent testEvent) {
        TransactionMode result = this.extractFromTestEvent(testEvent);
        if (TransactionMode.DEFAULT.equals((Object)result)) {
            result = ((TransactionConfiguration)this.configurationInstance.get()).getTransactionDefaultMode();
        }
        return result;
    }

    private TransactionMode extractFromTestEvent(TestEvent testEvent) {
        TransactionMode methodLevel = null;
        TransactionMode classLevel = null;
        TransactionEnablerLoader transactionEnablerLoader = new TransactionEnablerLoader((ServiceLoader)this.serviceLoaderInstance.get());
        for (TransactionEnabler enabler : transactionEnablerLoader.getTransactionEnablers()) {
            if (methodLevel == null && enabler.isTransactionHandlingDefinedOnMethodLevel(testEvent)) {
                methodLevel = enabler.getTransactionModeFromMethodLevel(testEvent);
            }
            if (classLevel != null || !enabler.isTransactionHandlingDefinedOnClassLevel(testEvent)) continue;
            classLevel = enabler.getTransactionModeFromClassLevel(testEvent);
        }
        if (methodLevel != null) {
            return methodLevel;
        }
        return classLevel;
    }

    private String getTransactionManager(TestEvent testEvent) {
        String transactionManager = "";
        Transactional transactional = testEvent.getTestMethod().getAnnotation(Transactional.class);
        if (transactional != null) {
            transactionManager = transactional.manager();
        }
        if (transactionManager.length() == 0 && (transactional = (Transactional)testEvent.getTestClass().getAnnotation(Transactional.class)) != null) {
            transactionManager = transactional.manager();
        }
        if (transactionManager.length() == 0) {
            transactionManager = this.obtainTranscationManagerFromConfiguration(transactionManager);
        }
        return transactionManager.length() != 0 ? transactionManager : null;
    }

    private String obtainTranscationManagerFromConfiguration(String transactionManager) {
        if (((TransactionConfiguration)this.configurationInstance.get()).getManager() != null) {
            transactionManager = ((TransactionConfiguration)this.configurationInstance.get()).getManager();
        }
        return transactionManager;
    }
}

