/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.transaction.impl.lifecycle;

import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.jboss.arquillian.transaction.impl.lifecycle.ModeChecker;
import org.jboss.arquillian.transaction.impl.lifecycle.TransactionProviderNotFoundException;
import org.jboss.arquillian.transaction.spi.provider.TransactionProvider;

public class TransactionProviderProducer {
    @Inject
    private Instance<ServiceLoader> serviceLoaderInstance;
    @Inject
    private Instance<Deployment> deploymentInstance;
    @Inject
    private Instance<Container> containerInstance;
    @Inject
    @TestScoped
    private InstanceProducer<TransactionProvider> transactionProviderProducer;

    public void registerTransactionProvider(@Observes(precedence=100) Before beforeTest) {
        if (!this.isTransactionSupported((TestEvent)beforeTest)) {
            return;
        }
        try {
            TransactionProvider transactionProvider = (TransactionProvider)((ServiceLoader)this.serviceLoaderInstance.get()).onlyOne(TransactionProvider.class);
            if (transactionProvider == null) {
                return;
            }
            this.transactionProviderProducer.set((Object)transactionProvider);
        }
        catch (IllegalStateException e) {
            throw new TransactionProviderNotFoundException("More then one transaction provider has been specified.", e);
        }
    }

    private boolean isTransactionSupported(TestEvent testEvent) {
        return new ModeChecker((Deployment)this.deploymentInstance.get(), (Container)this.containerInstance.get()).isClientMode(testEvent);
    }
}

