/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.util;

import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CEnumConstant;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CPropertyVisitor;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationUtils {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocumentBuilder() {
        try {
            return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new AssertionError((Object)pce);
        }
    }

    public static CPluginCustomization createCustomization(QName name) {
        Document document = CustomizationUtils.getDocumentBuilder().newDocument();
        Element element = document.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        return CustomizationUtils.createCustomization(element);
    }

    public static CPluginCustomization createCustomization(Element element) {
        CPluginCustomization customization = new CPluginCustomization(element, null);
        return customization;
    }

    public static boolean containsCustomization(Outline outline, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(outline, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static boolean containsCustomization(Model model, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(model, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static boolean containsCustomization(ClassOutline classOutline, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(classOutline, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static boolean containsCustomization(EnumOutline enumOutline, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(enumOutline, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static boolean containsCustomization(CClassInfo classInfo, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(classInfo, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static CPluginCustomization findCustomization(ClassOutline classOutline, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(classOutline);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(EnumOutline classOutline, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(classOutline);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(ElementOutline elementOutline, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(elementOutline);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static List<CPluginCustomization> findCustomizations(ClassOutline classOutline, QName name) {
        return CustomizationUtils.findCustomizations(classOutline.target, name);
    }

    public static List<CPluginCustomization> findCustomizations(EnumOutline enumOutline, QName name) {
        return CustomizationUtils.findCustomizations(enumOutline.target, name);
    }

    public static List<CPluginCustomization> findCustomizations(ElementOutline elementOutline, QName name) {
        return CustomizationUtils.findCustomizations(elementOutline.target, name);
    }

    public static List<CPluginCustomization> findCustomizations(CClassInfo classInfo, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(classInfo);
        LinkedList<CPluginCustomization> pluginCustomizations = new LinkedList<CPluginCustomization>();
        for (CPluginCustomization pluginCustomization : customizations) {
            if (!CustomizationUtils.fixNull(pluginCustomization.element.getNamespaceURI()).equals(name.getNamespaceURI()) || !CustomizationUtils.fixNull(pluginCustomization.element.getLocalName()).equals(name.getLocalPart())) continue;
            pluginCustomization.markAsAcknowledged();
            pluginCustomizations.add(pluginCustomization);
        }
        return pluginCustomizations;
    }

    public static List<CPluginCustomization> findCustomizations(CEnumLeafInfo enumInfo, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(enumInfo);
        LinkedList<CPluginCustomization> pluginCustomizations = new LinkedList<CPluginCustomization>();
        for (CPluginCustomization pluginCustomization : customizations) {
            if (!CustomizationUtils.fixNull(pluginCustomization.element.getNamespaceURI()).equals(name.getNamespaceURI()) || !CustomizationUtils.fixNull(pluginCustomization.element.getLocalName()).equals(name.getLocalPart())) continue;
            pluginCustomization.markAsAcknowledged();
            pluginCustomizations.add(pluginCustomization);
        }
        return pluginCustomizations;
    }

    public static List<CPluginCustomization> findCustomizations(CElementInfo elementInfo, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(elementInfo);
        LinkedList<CPluginCustomization> pluginCustomizations = new LinkedList<CPluginCustomization>();
        for (CPluginCustomization pluginCustomization : customizations) {
            if (!CustomizationUtils.fixNull(pluginCustomization.element.getNamespaceURI()).equals(name.getNamespaceURI()) || !CustomizationUtils.fixNull(pluginCustomization.element.getLocalName()).equals(name.getLocalPart())) continue;
            pluginCustomization.markAsAcknowledged();
            pluginCustomizations.add(pluginCustomization);
        }
        return pluginCustomizations;
    }

    public static List<CPluginCustomization> findCustomizations(Outline outline, QName name) {
        return CustomizationUtils.findCustomizations(outline.getModel(), name);
    }

    public static List<CPluginCustomization> findCustomizations(Model model, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(model);
        LinkedList<CPluginCustomization> pluginCustomizations = new LinkedList<CPluginCustomization>();
        for (CPluginCustomization pluginCustomization : customizations) {
            if (!CustomizationUtils.fixNull(pluginCustomization.element.getNamespaceURI()).equals(name.getNamespaceURI()) || !CustomizationUtils.fixNull(pluginCustomization.element.getLocalName()).equals(name.getLocalPart())) continue;
            pluginCustomization.markAsAcknowledged();
            pluginCustomizations.add(pluginCustomization);
        }
        return pluginCustomizations;
    }

    public static CPluginCustomization findCustomization(CClassInfo classInfo, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(classInfo);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(CEnumLeafInfo enumLeafInfo, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(enumLeafInfo);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(CElementInfo elementInfo, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(elementInfo);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static boolean containsCustomization(FieldOutline fieldOutline, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(fieldOutline, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static boolean containsCustomization(CEnumLeafInfo enumLeafInfo, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(enumLeafInfo, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static boolean containsCustomization(CPropertyInfo propertyInfo, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(propertyInfo, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static CPluginCustomization findCustomization(FieldOutline fieldOutline, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(fieldOutline);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(CPropertyInfo propertyInfo, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(propertyInfo);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(Outline outline, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(outline);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(Model model, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(model);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static FieldOutline findFieldWithCustomization(ClassOutline classOutline, QName name) {
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            CCustomizations customizations = CustomizationUtils.getCustomizations(fieldOutline);
            CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
            if (customization == null) continue;
            return fieldOutline;
        }
        return null;
    }

    public static CPropertyInfo findPropertyWithCustomization(CClassInfo classInfo, QName name) {
        for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
            CCustomizations customizations = CustomizationUtils.getCustomizations(propertyInfo);
            CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
            if (customization == null) continue;
            return propertyInfo;
        }
        return null;
    }

    public static FieldOutline findInheritedFieldWithCustomization(ClassOutline classOutline, QName name) {
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            if (!CustomizationUtils.containsCustomization(fieldOutline, name)) continue;
            return fieldOutline;
        }
        ClassOutline superClassOutline = classOutline.getSuperClass();
        if (superClassOutline != null) {
            return CustomizationUtils.findInheritedFieldWithCustomization(superClassOutline, name);
        }
        return null;
    }

    public static CPropertyInfo findInheritedPropertyWithCustomization(CClassInfo classInfo, QName name) {
        for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
            if (!CustomizationUtils.containsCustomization(propertyInfo, name)) continue;
            return propertyInfo;
        }
        CClassInfo superClassInfo = classInfo.getBaseClass();
        if (superClassInfo != null) {
            return CustomizationUtils.findInheritedPropertyWithCustomization(superClassInfo, name);
        }
        return null;
    }

    public static CCustomizations getCustomizations(ElementOutline elementOutline) {
        return CustomizationUtils.getCustomizations(elementOutline.target);
    }

    public static CCustomizations getCustomizations(CElementInfo elementInfo) {
        return elementInfo.getCustomizations();
    }

    public static CCustomizations getCustomizations(EnumOutline enumOutline) {
        return CustomizationUtils.getCustomizations(enumOutline.target);
    }

    public static CCustomizations getCustomizations(EnumConstantOutline enumConstantOutline) {
        return CustomizationUtils.getCustomizations(enumConstantOutline.target);
    }

    public static CCustomizations getCustomizations(FieldOutline fieldOutline) {
        return CustomizationUtils.getCustomizations(fieldOutline.getPropertyInfo());
    }

    public static CCustomizations getCustomizations(Outline outline) {
        return CustomizationUtils.getCustomizations(outline.getModel());
    }

    public static CCustomizations getCustomizations(Model model) {
        CCustomizations main = new CCustomizations((Collection)model.getCustomizations());
        return main;
    }

    public static CCustomizations getCustomizations(CPropertyInfo propertyInfo) {
        CCustomizations main = new CCustomizations((Collection)propertyInfo.getCustomizations());
        Collection elementCustomizations = (Collection)propertyInfo.accept((CPropertyVisitor)new CPropertyVisitor<Collection<CCustomizations>>(){

            public Collection<CCustomizations> onAttribute(CAttributePropertyInfo info) {
                return Collections.emptyList();
            }

            public Collection<CCustomizations> onElement(CElementPropertyInfo arg0) {
                return Collections.emptyList();
            }

            public Collection<CCustomizations> onReference(CReferencePropertyInfo info) {
                ArrayList<CCustomizations> elementCustomizations = new ArrayList<CCustomizations>(info.getElements().size());
                for (CElement element : info.getElements()) {
                    if (element instanceof CElementInfo && ((CElementInfo)element).hasClass()) continue;
                    elementCustomizations.add(element.getCustomizations());
                }
                return elementCustomizations;
            }

            public Collection<CCustomizations> onValue(CValuePropertyInfo arg0) {
                return Collections.emptyList();
            }
        });
        CCustomizations customizations = main;
        for (CCustomizations e : elementCustomizations) {
            main.addAll((Collection)e);
        }
        return customizations;
    }

    public static CCustomizations getCustomizations(ClassOutline classOutline) {
        return CustomizationUtils.getCustomizations(classOutline.target);
    }

    public static CCustomizations getCustomizations(CClassInfo classInfo) {
        return classInfo.getCustomizations();
    }

    public static CCustomizations getCustomizations(CEnumLeafInfo enumLeafInfo) {
        return enumLeafInfo.getCustomizations();
    }

    public static CCustomizations getCustomizations(CEnumConstant enumConstant) {
        CEnumConstant _enumConstant = enumConstant;
        if (_enumConstant instanceof CCustomizable) {
            return ((CCustomizable)_enumConstant).getCustomizations();
        }
        return CCustomizations.EMPTY;
    }

    private static String fixNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static Object unmarshall(JAXBContext context, CPluginCustomization customization) throws AssertionError {
        Unmarshaller unmarshaller;
        if (customization == null) {
            return null;
        }
        try {
            unmarshaller = context.createUnmarshaller();
        }
        catch (JAXBException ex) {
            AssertionError error = new AssertionError((Object)"Unmarshaller could not be created.");
            ((Throwable)((Object)error)).initCause(ex);
            throw error;
        }
        try {
            Object result = unmarshaller.unmarshal((Source)new DOMSource(customization.element));
            JAXBIntrospector introspector = context.createJAXBIntrospector();
            if (introspector.isElement(result)) {
                return JAXBIntrospector.getValue((Object)result);
            }
            return result;
        }
        catch (JAXBException ex) {
            throw new IllegalArgumentException("Could not unmarshal the customization.", ex);
        }
    }

    public static CPluginCustomization marshal(JAXBContext context, QName name, Object object) {
        try {
            Element element;
            Object value;
            JAXBIntrospector introspector = context.createJAXBIntrospector();
            if (introspector.isElement(object)) {
                value = object;
            } else {
                JAXBElement jaxbElement = new JAXBElement(name, object.getClass(), object);
                value = jaxbElement;
            }
            Marshaller marshaller = context.createMarshaller();
            DOMResult result = new DOMResult();
            marshaller.marshal(value, (Result)result);
            Node node = result.getNode();
            if (node instanceof Element) {
                element = (Element)node;
            } else if (node instanceof Document) {
                element = ((Document)node).getDocumentElement();
            } else {
                Object element2 = null;
                throw new IllegalArgumentException("Could not marhsall object into an element.");
            }
            return new CPluginCustomization(element, null);
        }
        catch (JAXBException jaxbex) {
            throw new IllegalArgumentException("Could not marhsall object into an element.", jaxbex);
        }
    }

    public static CPluginCustomization addCustomization(CCustomizable customizable, JAXBContext context, QName name, Object object) {
        CPluginCustomization customization = CustomizationUtils.marshal(context, name, object);
        customizable.getCustomizations().add((Object)customization);
        return customization;
    }
}

