/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.events.internal;

import org.springframework.core.GenericTypeResolver;
import org.springframework.util.Assert;
import org.vaadin.spring.events.Event;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.EventBusListener;
import org.vaadin.spring.events.internal.AbstractListenerWrapper;

class EventBusListenerWrapper
extends AbstractListenerWrapper {
    private static final long serialVersionUID = 8964309195124823892L;
    private final Class<?> payloadType;

    public EventBusListenerWrapper(EventBus owningEventBus, EventBusListener<?> listenerTarget, boolean includingPropagatingEvents) {
        super(owningEventBus, listenerTarget, includingPropagatingEvents);
        this.payloadType = GenericTypeResolver.resolveTypeArgument(listenerTarget.getClass(), EventBusListener.class);
        Assert.notNull(this.payloadType, (String)"Could not resolve payload type");
    }

    @Override
    public EventBusListener getListenerTarget() {
        return (EventBusListener)super.getListenerTarget();
    }

    @Override
    protected Class<?> getPayloadType() {
        return this.payloadType;
    }

    @Override
    public void publish(Event<?> event) {
        this.getListenerTarget().onEvent(event);
    }
}

