/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.events.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.spring.events.Event;

class ListenerCollection
implements Serializable {
    private static final long serialVersionUID = -6237902400879667320L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<Listener> listeners = new HashSet<Listener>();

    ListenerCollection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Listener listener) {
        this.logger.trace("Adding listener [{}]", (Object)listener);
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Listener listener) {
        this.logger.trace("Removing listener [{}]", (Object)listener);
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ListenerFilter filter) {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.removeFilteredListenersFromSet(filter, this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Event<?> event) {
        HashSet<Listener> interestedListeners = new HashSet<Listener>();
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.addSupportedListenersToSet(this.listeners, interestedListeners, event);
        }
        if (interestedListeners.isEmpty()) {
            this.logger.debug("No listeners supported event [{}]", event);
        } else {
            for (Listener listener : interestedListeners) {
                this.logger.trace("Publishing event [{}] to listener [{}]", event, (Object)listener);
                listener.publish(event);
            }
        }
    }

    private <T> void addSupportedListenersToSet(Set<Listener> candidateListeners, Set<Listener> selectedListeners, Event<T> event) {
        for (Listener candidateListener : candidateListeners) {
            if (!candidateListener.supports(event)) continue;
            this.logger.trace("Listener [{}] supports event [{}]", (Object)candidateListener, event);
            selectedListeners.add(candidateListener);
        }
    }

    private void removeFilteredListenersFromSet(ListenerFilter filter, Set<Listener> listenerSet) {
        Iterator<Listener> it = listenerSet.iterator();
        while (it.hasNext()) {
            Listener listener = it.next();
            if (!filter.passes(listener)) continue;
            this.logger.trace("Removing listener [{}]", (Object)listener);
            it.remove();
        }
    }

    public static interface ListenerFilter {
        public boolean passes(Listener var1);
    }

    public static interface Listener
    extends Serializable {
        public boolean supports(Event<?> var1);

        public void publish(Event<?> var1);
    }
}

