/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityRolesAssociation;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    public static final String AUTH_EXCEPTION_KEY = "org.jboss.security.exception";

    SecurityActions() {
    }

    static SecurityContext createSecurityContext(final String domain) {
        if (WildFlySecurityManager.isChecking()) {
            return (SecurityContext)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<SecurityContext>(){

                @Override
                public SecurityContext run() {
                    try {
                        return SecurityContextFactory.createSecurityContext((String)domain);
                    }
                    catch (Exception e) {
                        throw UndertowLogger.ROOT_LOGGER.failToCreateSecurityContext(e);
                    }
                }
            });
        }
        try {
            return SecurityContextFactory.createSecurityContext((String)domain);
        }
        catch (Exception e) {
            throw UndertowLogger.ROOT_LOGGER.failToCreateSecurityContext(e);
        }
    }

    static void setSecurityContextOnAssociation(final SecurityContext sc) {
        if (WildFlySecurityManager.isChecking()) {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                    return null;
                }
            });
        } else {
            SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
        }
    }

    static SecurityContext getSecurityContext() {
        if (WildFlySecurityManager.isChecking()) {
            return (SecurityContext)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<SecurityContext>(){

                @Override
                public SecurityContext run() {
                    return SecurityContextAssociation.getSecurityContext();
                }
            });
        }
        return SecurityContextAssociation.getSecurityContext();
    }

    static void clearSecurityContext() {
        if (WildFlySecurityManager.isChecking()) {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityContextAssociation.clearSecurityContext();
                    return null;
                }
            });
        } else {
            SecurityContextAssociation.clearSecurityContext();
        }
    }

    static void setSecurityRoles(final Map<String, Set<String>> roles) {
        if (WildFlySecurityManager.isChecking()) {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityRolesAssociation.setSecurityRoles((Map)roles);
                    return null;
                }
            });
        } else {
            SecurityRolesAssociation.setSecurityRoles(roles);
        }
    }

    static RunAs setRunAsIdentity(final RunAs principal, final SecurityContext sc) {
        if (WildFlySecurityManager.isChecking()) {
            return (RunAs)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<RunAs>(){

                @Override
                public RunAs run() {
                    if (sc == null) {
                        throw UndertowLogger.ROOT_LOGGER.noSecurityContext();
                    }
                    RunAs old = sc.getOutgoingRunAs();
                    sc.setOutgoingRunAs(principal);
                    return old;
                }
            });
        }
        if (sc == null) {
            throw UndertowLogger.ROOT_LOGGER.noSecurityContext();
        }
        RunAs old = sc.getOutgoingRunAs();
        sc.setOutgoingRunAs(principal);
        return old;
    }

    static RunAs popRunAsIdentity(final SecurityContext sc) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<RunAs>(){

                @Override
                public RunAs run() {
                    if (sc == null) {
                        throw UndertowLogger.ROOT_LOGGER.noSecurityContext();
                    }
                    RunAs principal = sc.getOutgoingRunAs();
                    sc.setOutgoingRunAs(null);
                    return principal;
                }
            });
        }
        if (sc == null) {
            throw UndertowLogger.ROOT_LOGGER.noSecurityContext();
        }
        RunAs principal = sc.getOutgoingRunAs();
        sc.setOutgoingRunAs(null);
        return principal;
    }

    public static RunAs getRunAsIdentity(final SecurityContext sc) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<RunAs>(){

                @Override
                public RunAs run() {
                    if (sc == null) {
                        throw UndertowLogger.ROOT_LOGGER.noSecurityContext();
                    }
                    return sc.getOutgoingRunAs();
                }
            });
        }
        if (sc == null) {
            throw UndertowLogger.ROOT_LOGGER.noSecurityContext();
        }
        return sc.getOutgoingRunAs();
    }

    static Subject getSubject() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                @Override
                public Subject run() {
                    Subject subject = null;
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    if (sc != null) {
                        subject = sc.getUtil().getSubject();
                    }
                    return subject;
                }
            });
        }
        Subject subject = null;
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc != null) {
            subject = sc.getUtil().getSubject();
        }
        return subject;
    }
}

