/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderAsync;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderClient;
import com.amazonaws.services.elastictranscoder.model.CancelJobRequest;
import com.amazonaws.services.elastictranscoder.model.CancelJobResult;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.CreateJobResult;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePresetResult;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineResult;
import com.amazonaws.services.elastictranscoder.model.DeletePresetRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePresetResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusResult;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesRequest;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesResult;
import com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.amazonaws.services.elastictranscoder.model.ListPresetsResult;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.services.elastictranscoder.model.ReadJobResult;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPresetResult;
import com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.amazonaws.services.elastictranscoder.model.TestRoleResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticTranscoderAsyncClient
extends AmazonElasticTranscoderClient
implements AmazonElasticTranscoderAsync {
    private ExecutorService executorService;

    public AmazonElasticTranscoderAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElasticTranscoderAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<UpdatePipelineStatusResult> updatePipelineStatusAsync(final UpdatePipelineStatusRequest updatePipelineStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdatePipelineStatusResult>(){

            @Override
            public UpdatePipelineStatusResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.updatePipelineStatus(updatePipelineStatusRequest);
            }
        });
    }

    @Override
    public Future<UpdatePipelineStatusResult> updatePipelineStatusAsync(final UpdatePipelineStatusRequest updatePipelineStatusRequest, final AsyncHandler<UpdatePipelineStatusRequest, UpdatePipelineStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdatePipelineStatusResult>(){

            @Override
            public UpdatePipelineStatusResult call() throws Exception {
                UpdatePipelineStatusResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.updatePipelineStatus(updatePipelineStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updatePipelineStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineNotificationsResult> updatePipelineNotificationsAsync(final UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdatePipelineNotificationsResult>(){

            @Override
            public UpdatePipelineNotificationsResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.updatePipelineNotifications(updatePipelineNotificationsRequest);
            }
        });
    }

    @Override
    public Future<UpdatePipelineNotificationsResult> updatePipelineNotificationsAsync(final UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest, final AsyncHandler<UpdatePipelineNotificationsRequest, UpdatePipelineNotificationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdatePipelineNotificationsResult>(){

            @Override
            public UpdatePipelineNotificationsResult call() throws Exception {
                UpdatePipelineNotificationsResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.updatePipelineNotifications(updatePipelineNotificationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updatePipelineNotificationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReadJobResult> readJobAsync(final ReadJobRequest readJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReadJobResult>(){

            @Override
            public ReadJobResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.readJob(readJobRequest);
            }
        });
    }

    @Override
    public Future<ReadJobResult> readJobAsync(final ReadJobRequest readJobRequest, final AsyncHandler<ReadJobRequest, ReadJobResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReadJobResult>(){

            @Override
            public ReadJobResult call() throws Exception {
                ReadJobResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.readJob(readJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(readJobRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsByStatusResult> listJobsByStatusAsync(final ListJobsByStatusRequest listJobsByStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListJobsByStatusResult>(){

            @Override
            public ListJobsByStatusResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.listJobsByStatus(listJobsByStatusRequest);
            }
        });
    }

    @Override
    public Future<ListJobsByStatusResult> listJobsByStatusAsync(final ListJobsByStatusRequest listJobsByStatusRequest, final AsyncHandler<ListJobsByStatusRequest, ListJobsByStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListJobsByStatusResult>(){

            @Override
            public ListJobsByStatusResult call() throws Exception {
                ListJobsByStatusResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.listJobsByStatus(listJobsByStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listJobsByStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReadPresetResult> readPresetAsync(final ReadPresetRequest readPresetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReadPresetResult>(){

            @Override
            public ReadPresetResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.readPreset(readPresetRequest);
            }
        });
    }

    @Override
    public Future<ReadPresetResult> readPresetAsync(final ReadPresetRequest readPresetRequest, final AsyncHandler<ReadPresetRequest, ReadPresetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReadPresetResult>(){

            @Override
            public ReadPresetResult call() throws Exception {
                ReadPresetResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.readPreset(readPresetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(readPresetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest createPipelineRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.createPipeline(createPipelineRequest);
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest createPipelineRequest, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.createPipeline(createPipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createPipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(final CancelJobRequest cancelJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.cancelJob(cancelJobRequest);
            }
        });
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(final CancelJobRequest cancelJobRequest, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.cancelJob(cancelJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(cancelJobRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(final UpdatePipelineRequest updatePipelineRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.updatePipeline(updatePipelineRequest);
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(final UpdatePipelineRequest updatePipelineRequest, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.updatePipeline(updatePipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updatePipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(final ListPresetsRequest listPresetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPresetsResult>(){

            @Override
            public ListPresetsResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.listPresets(listPresetsRequest);
            }
        });
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(final ListPresetsRequest listPresetsRequest, final AsyncHandler<ListPresetsRequest, ListPresetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPresetsResult>(){

            @Override
            public ListPresetsResult call() throws Exception {
                ListPresetsResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.listPresets(listPresetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listPresetsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(final DeletePipelineRequest deletePipelineRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeletePipelineResult>(){

            @Override
            public DeletePipelineResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.deletePipeline(deletePipelineRequest);
            }
        });
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(final DeletePipelineRequest deletePipelineRequest, final AsyncHandler<DeletePipelineRequest, DeletePipelineResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeletePipelineResult>(){

            @Override
            public DeletePipelineResult call() throws Exception {
                DeletePipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.deletePipeline(deletePipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deletePipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<TestRoleResult> testRoleAsync(final TestRoleRequest testRoleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TestRoleResult>(){

            @Override
            public TestRoleResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.testRole(testRoleRequest);
            }
        });
    }

    @Override
    public Future<TestRoleResult> testRoleAsync(final TestRoleRequest testRoleRequest, final AsyncHandler<TestRoleRequest, TestRoleResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TestRoleResult>(){

            @Override
            public TestRoleResult call() throws Exception {
                TestRoleResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.testRole(testRoleRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(testRoleRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest listPipelinesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.listPipelines(listPipelinesRequest);
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest listPipelinesRequest, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.listPipelines(listPipelinesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listPipelinesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReadPipelineResult> readPipelineAsync(final ReadPipelineRequest readPipelineRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReadPipelineResult>(){

            @Override
            public ReadPipelineResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.readPipeline(readPipelineRequest);
            }
        });
    }

    @Override
    public Future<ReadPipelineResult> readPipelineAsync(final ReadPipelineRequest readPipelineRequest, final AsyncHandler<ReadPipelineRequest, ReadPipelineResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReadPipelineResult>(){

            @Override
            public ReadPipelineResult call() throws Exception {
                ReadPipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.readPipeline(readPipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(readPipelineRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreatePresetResult> createPresetAsync(final CreatePresetRequest createPresetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePresetResult>(){

            @Override
            public CreatePresetResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.createPreset(createPresetRequest);
            }
        });
    }

    @Override
    public Future<CreatePresetResult> createPresetAsync(final CreatePresetRequest createPresetRequest, final AsyncHandler<CreatePresetRequest, CreatePresetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreatePresetResult>(){

            @Override
            public CreatePresetResult call() throws Exception {
                CreatePresetResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.createPreset(createPresetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createPresetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeletePresetResult> deletePresetAsync(final DeletePresetRequest deletePresetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeletePresetResult>(){

            @Override
            public DeletePresetResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.deletePreset(deletePresetRequest);
            }
        });
    }

    @Override
    public Future<DeletePresetResult> deletePresetAsync(final DeletePresetRequest deletePresetRequest, final AsyncHandler<DeletePresetRequest, DeletePresetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeletePresetResult>(){

            @Override
            public DeletePresetResult call() throws Exception {
                DeletePresetResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.deletePreset(deletePresetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deletePresetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(final CreateJobRequest createJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.createJob(createJobRequest);
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(final CreateJobRequest createJobRequest, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.createJob(createJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createJobRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsByPipelineResult> listJobsByPipelineAsync(final ListJobsByPipelineRequest listJobsByPipelineRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListJobsByPipelineResult>(){

            @Override
            public ListJobsByPipelineResult call() throws Exception {
                return AmazonElasticTranscoderAsyncClient.this.listJobsByPipeline(listJobsByPipelineRequest);
            }
        });
    }

    @Override
    public Future<ListJobsByPipelineResult> listJobsByPipelineAsync(final ListJobsByPipelineRequest listJobsByPipelineRequest, final AsyncHandler<ListJobsByPipelineRequest, ListJobsByPipelineResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListJobsByPipelineResult>(){

            @Override
            public ListJobsByPipelineResult call() throws Exception {
                ListJobsByPipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.listJobsByPipeline(listJobsByPipelineRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listJobsByPipelineRequest, result);
                return result;
            }
        });
    }
}

