/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.changelog;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.changelog.AbstractChangeLogEntry;
import com.helger.commons.changelog.ChangeLog;
import com.helger.commons.changelog.EChangeLogAction;
import com.helger.commons.changelog.EChangeLogCategory;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.IMutableMultilingualText;
import com.helger.commons.text.MultilingualText;
import com.helger.commons.text.ReadOnlyMultilingualText;
import java.time.LocalDate;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ChangeLogEntry
extends AbstractChangeLogEntry {
    private final ChangeLog m_aChangeLog;
    private final EChangeLogAction m_eAction;
    private final EChangeLogCategory m_eCategory;
    private final boolean m_bIsIncompatible;
    private final IMutableMultilingualText m_aTexts = new MultilingualText();
    private final ICommonsList<String> m_aIssues = new CommonsArrayList<String>();

    public ChangeLogEntry(@Nonnull ChangeLog changeLog, @Nonnull LocalDate localDate, @Nonnull EChangeLogAction eChangeLogAction, @Nonnull EChangeLogCategory eChangeLogCategory, boolean bl) {
        super(localDate);
        this.m_aChangeLog = ValueEnforcer.notNull(changeLog, "ChangeLog");
        this.m_eAction = ValueEnforcer.notNull(eChangeLogAction, "Action");
        this.m_eCategory = ValueEnforcer.notNull(eChangeLogCategory, "Category");
        this.m_bIsIncompatible = bl;
    }

    @Nonnull
    public ChangeLog getChangeLog() {
        return this.m_aChangeLog;
    }

    @Nonnull
    @Nonempty
    public String getChangeLogComponent() {
        return this.m_aChangeLog.getComponent();
    }

    @Nonnull
    public EChangeLogAction getAction() {
        return this.m_eAction;
    }

    @Nonnull
    public EChangeLogCategory getCategory() {
        return this.m_eCategory;
    }

    public boolean isIncompatible() {
        return this.m_bIsIncompatible;
    }

    @Nonnull
    public EChange setText(@Nonnull IMultilingualText iMultilingualText) {
        ValueEnforcer.notNull(iMultilingualText, "MLT");
        return this.m_aTexts.assignFrom(iMultilingualText);
    }

    @Nonnull
    public EChange setText(@Nonnull Locale locale, @Nullable String string) {
        String string2 = StringHelper.trim(string);
        if (StringHelper.hasNoText(string2)) {
            return EChange.UNCHANGED;
        }
        return this.m_aTexts.setText(locale, string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public IMultilingualText getAllTexts() {
        return new ReadOnlyMultilingualText(this.m_aTexts);
    }

    @Nullable
    public String getText(@Nonnull Locale locale) {
        return this.m_aTexts.getText(locale);
    }

    @Nonnull
    public EChange addIssue(@Nullable String string) {
        String string2 = StringHelper.trim(string);
        if (StringHelper.hasNoText(string2)) {
            return EChange.UNCHANGED;
        }
        this.m_aIssues.add(string2);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllIssues() {
        return (ICommonsList)this.m_aIssues.getClone();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ChangeLogEntry changeLogEntry = (ChangeLogEntry)object;
        return this.m_aChangeLog.getComponent().equals(changeLogEntry.m_aChangeLog.getComponent()) && this.m_eAction.equals(changeLogEntry.m_eAction) && this.m_eCategory.equals(changeLogEntry.m_eCategory) && this.m_bIsIncompatible == changeLogEntry.m_bIsIncompatible && this.m_aTexts.equals(changeLogEntry.m_aTexts) && this.m_aIssues.equals(changeLogEntry.m_aIssues);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aChangeLog.getComponent()).append((Enum)this.m_eAction)).append((Enum)this.m_eCategory)).append(this.m_bIsIncompatible).append(this.m_aTexts).append(this.m_aIssues)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Changelog", this.m_aChangeLog.getComponent()).append("Action", this.m_eAction).append("Category", this.m_eCategory).append("Incompatible", this.m_bIsIncompatible).append("Texts", this.m_aTexts).append("Issues", this.m_aIssues).getToString();
    }
}

