package com.levigo.util.cpsupp;

import com.levigo.util.log.Logger;
import com.levigo.util.log.LoggerFactory;

/*
 * Copyright (c) 1995-2007 levigo holding gmbh. All Rights Reserved.
 * 
 * This software is the proprietary information of levigo holding gmbh Use is
 * subject to license terms.
 */


/**
 * Class declaration
 *
 *
 * @author
 * @version %I%, %G%
 */
public class CpConvert {
	private static final Logger log = LoggerFactory
	.getLogger(CpConvert.class);
  byte[] cvTable = null;
  String encoder = null;
  private byte[] revData = null;

  /**
   * Class declaration
   *
   *
   * @author
   * @version %I%, %G%
   */
  class CpNode {
    int cpValue;
    CpConvert cpClass;

    /**
     * Constructor declaration
     *
     *
     * @param cpValue
     * @param cpClass
     *
     * @see
     */
    CpNode(int cpValue, CpConvert cpClass) {
      this.cpValue = cpValue;
      this.cpClass = cpClass;
    }

  }

  static CpConvert cpConvert = new CpConvert();
  static CpNode[] codePages =
    {
      cpConvert.new CpNode(1004, new CpConvert(1004)),
      cpConvert.new CpNode(382, new Cp382()),
      cpConvert.new CpNode(280, new Cp280()),
      cpConvert.new CpNode(285, new Cp285()),
      cpConvert.new CpNode(273, new Cp273()),
      cpConvert.new CpNode(850, new Cp850()),
      cpConvert.new CpNode(500, new Cp500()),
      cpConvert.new CpNode(37, new Cp037()),
      cpConvert.new CpNode(437, new Cp437()),
      cpConvert.new CpNode(1250, new Cp1250()),
      cpConvert.new CpNode(1252, new Cp1252()),
      cpConvert.new CpNode(1025, new Cp1025()),
      cpConvert.new CpNode(2067, new Cp273())};
  static {
    codePages[0].cpClass.encoder = "8859_1";
  }

  /**
   * Documentation currently unavailable
   * @return byte[]
   * @param input byte[]
   */
  private final synchronized byte[] convert(
    byte[] input,
    int offset,
    int length) {
    if (cvTable == null) {
      cvTable = getTable();
    }

    byte[] retData = new byte[length];

    for (int i = length; --i >= 0;) {
      retData[i] = cvTable[(0xFF & input[i + offset])];
    }

    return retData;
  }
  /**
   * Returns the string encoded with the relevant codepage.
   * @return The encoded data
   * @param javaString The string to be encoded
   */
  public byte[] encode(String javaString)
    throws java.io.UnsupportedEncodingException {
    byte[] raw = javaString.getBytes("8859_1");

    /*
     * Support for the euro-character:
     * This is the reverse hack to the one in the toString method below.
     * If we encounter the euro-character (which, for reasons detailed below, 
     * can only be found in the char-array), we output a iso8859-15 euro-character.
     */
    char[] rawChars = javaString.toCharArray();
    for (int i = 0; i < rawChars.length; i++) {
      if (rawChars[i] == '\u20ac')
        raw[i] = (byte) 0xa4;
    }

    byte[] ret = new byte[raw.length];
    byte[] revtabel = getRevTable();

    for (int i = 0; i < raw.length; i++) {
      ret[i] = revtabel[(0xFF & raw[i])];
    }

    return ret;
  }
  /**
   * Documentation currently unavailable
   * @return com.bm_soft.util.cpsupp.CpConvert
   * @param codePage int
   */
  public static CpConvert getConv(int codePage) {
    for (int i = 0; i < codePages.length; i++) {
      if (codePages[i].cpValue == codePage) {
        return codePages[i].cpClass;
      }
    }

    return new CpConvert(codePage);
  }
  /**
   * Documentation currently unavailable
   * @return byte[]
   */
  protected byte[] getRevTable() {
    if (revData == null) {
      try {
        byte[] data = new byte[256];

        for (int i = 0; i < data.length; i++) {
          data[i] = (byte) i;
        }

        String val = new String(data, "8859_1");

        revData = val.getBytes(encoder);
      } catch (java.io.UnsupportedEncodingException e) {
        if (log.isDebugEnabled())
      		log.debug("Unsupported encoding " + encoder);
      }
    }

    return revData;
  }
  /**
   * Documentation currently unavailable
   * @return byte[]
   */
  protected byte[] getTable() {
    return null;
  }
  /**
   * Documentation currently unavailable
   * @param cpNumber int
   */
  private CpConvert(int cpNumber) {
    if (cpNumber < 100) {
      encoder = "Cp0" + cpNumber;
    } else {
      encoder = "Cp" + cpNumber;
    }
  }
  /**
   * Documentation currently unavailable
   * @return byte[]
   * @param input byte[]
   */
  public String toString(byte[] input, int offset, int length)
    throws java.io.UnsupportedEncodingException {
    if (encoder != null) {
      try {
        return new String(input, offset, length, encoder);
      } catch (java.io.UnsupportedEncodingException X) {
        throw new java.io.UnsupportedEncodingException(
          "Can't decode: \"" + encoder + "\"");
      }
    }

    byte[] data = convert(input, offset, length);

    /*
     * Support for the "euro-character":
     * The unicode code for the euro is \u20ac. The constructor String(byte [], "8859_1") call will
     * perform conversion in a way that the values of the byte array are simply extended to 16-bit
     * unicode characters, because the bottom 256 entries of the unicode character match
     * the iso8859-1 set.
     * There is a new ISO recommendation 8859-15 which equals 8859-1 with a few replacements.
     * Most significantly, the 8859-1 character for the "General Currency Sign" has been replaced
     * by the euro-sign in 8815-15.
     * Unfortunately, Java doesn't support conversion based on 8815-15 yet, therefore we "hand-tune"
     * the conversion here.
     * 
     * FIXME:
     * This is a very ugly hack, but there's no simple solution. A better solution would be to
     * let the CodePage converters convert directly to and from unicode (16-bit data).
     */
    String result = new String(data, "8859_1").replace('\u00a4', '\u20ac');
    // "General Currency Sign" -> "euro"
    return result;
  }
  /**
   * Documentation currently unavailable
   * @return byte[]
   * @param input byte[]
   */
  public String toString(byte[] input)
    throws java.io.UnsupportedEncodingException {
    return toString(input, 0, input.length);
  }
  /**
   * Documentation currently unavailable
   */
  protected CpConvert() {
  }
}
