/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui.notification;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.PopupPanel;
import com.vaadin.client.ServerConnector;
import com.vaadin.client.extensions.AbstractExtensionConnector;
import com.vaadin.client.ui.VNotification;
import com.vaadin.shared.ui.Connect;
import com.vaadin.shared.ui.notification.NotificationServerRpc;
import com.vaadin.shared.ui.notification.NotificationState;
import com.vaadin.ui.Notification;

/**
 * The client-side connector for the {@code Notification}.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.2
 */
@Connect(value = Notification.class)
public class NotificationConnector extends AbstractExtensionConnector {

    private VNotification notification;

    @Override
    public NotificationState getState() {
        return (NotificationState) super.getState();
    }

    @Override
    protected void extend(ServerConnector target) {
        NotificationState state = getState();
        notification = VNotification.showNotification(target.getConnection(),
                state.caption, state.description, state.htmlContentAllowed,
                getResourceUrl("icon"), state.styleName, state.position,
                state.delay);

        notification.addCloseHandler(new CloseHandler<PopupPanel>() {

            @Override
            public void onClose(CloseEvent<PopupPanel> event) {
                if (getParent() == null) {
                    // Unregistered already
                    return;
                }
                NotificationServerRpc rpc = getRpcProxy(
                        NotificationServerRpc.class);
                rpc.closed();
                notification = null;
            }
        });
    }

    @Override
    public void onUnregister() {
        super.onUnregister();
        if (notification != null) {
            notification.hide();
            notification = null;
        }
    }
}
