/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools.commands.exportcmd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.server.configuration.ServerStartupConfiguration;
import org.apache.directory.server.tools.ToolCommandListener;
import org.apache.directory.server.tools.execution.BaseToolCommandExecutor;
import org.apache.directory.server.tools.util.ListenerParameter;
import org.apache.directory.server.tools.util.Parameter;
import org.apache.directory.server.tools.util.ToolCommandException;
import org.apache.directory.shared.ldap.ldif.LdifComposerImpl;
import org.apache.directory.shared.ldap.util.MultiMap;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ExportCommandExecutor
extends BaseToolCommandExecutor {
    public static final String BASEDN_PARAMETER = "baseDN";
    public static final String EXPORTPOINT_PARAMETER = "exportPoint";
    public static final String SCOPE_PARAMETER = "scope";
    public static final String FILE_PARAMETER = "file";
    public static final String ENTRYWRITTENLISTENER_PARAMETER = "entryWrittenListener";
    public static final String SCOPE_OBJECT = "object";
    public static final String SCOPE_ONELEVEL = "onelevel";
    public static final String SCOPE_SUBTREE = "subtree";
    private String baseDN;
    private static final String DEFAULT_BASEDN = "";
    private String exportPoint;
    private static final String DEFAULT_EXPORTPOINT = "";
    private int scope;
    private static final int DEFAULT_SCOPE = 2;
    private String ldifFileName;
    private ToolCommandListener entryWrittenListener;

    public ExportCommandExecutor() {
        super("export");
    }

    public void execute(Parameter[] params, ListenerParameter[] listeners) {
        this.processParameters(params);
        this.processListeners(listeners);
        try {
            this.execute();
        }
        catch (Exception e) {
            this.notifyExceptionListener(e);
        }
    }

    private void execute() throws Exception {
        NamingEnumeration entries = this.connectToServerAndGetEntries();
        File destionationFile = new File(this.ldifFileName);
        if (destionationFile.exists()) {
            destionationFile.delete();
        }
        FileWriter fw = new FileWriter(this.ldifFileName, true);
        BufferedWriter writer = new BufferedWriter(fw);
        LdifComposerImpl composer = new LdifComposerImpl();
        MultiValueMap map = new MultiValueMap();
        int entriesCounter = 1;
        long t0 = System.currentTimeMillis();
        while (entries.hasMoreElements()) {
            SearchResult sr = (SearchResult)entries.nextElement();
            Attributes attributes = sr.getAttributes();
            NamingEnumeration<? extends Attribute> attributesEnumeration = attributes.getAll();
            map.clear();
            while (attributesEnumeration.hasMoreElements()) {
                Attribute attr = (Attribute)attributesEnumeration.nextElement();
                NamingEnumeration<?> e2 = null;
                e2 = attr.getAll();
                while (e2.hasMoreElements()) {
                    Object value = e2.nextElement();
                    map.put((Object)attr.getID(), value);
                }
            }
            writer.write("dn: " + sr.getNameInNamespace() + "\n");
            writer.write(composer.compose((MultiMap)map) + "\n");
            this.notifyEntryWrittenListener((Serializable)((Object)sr.getNameInNamespace()));
            if (++entriesCounter % 10 == 0) {
                this.notifyOutputListener(new Character('.'));
            }
            if (entriesCounter % 500 != 0) continue;
            this.notifyOutputListener((Serializable)((Object)("" + entriesCounter)));
        }
        writer.flush();
        writer.close();
        fw.close();
        long t1 = System.currentTimeMillis();
        this.notifyOutputListener((Serializable)((Object)"Done!"));
        this.notifyOutputListener((Serializable)((Object)(entriesCounter + " entries exported in " + (t1 - t0) / 1000L + " seconds")));
    }

    public NamingEnumeration connectToServerAndGetEntries() throws ToolCommandException {
        InitialDirContext ctx;
        if (this.isDebugEnabled()) {
            this.notifyOutputListener((Serializable)((Object)"Connecting to LDAP server"));
            this.notifyOutputListener((Serializable)((Object)("Host: " + this.host)));
            this.notifyOutputListener((Serializable)((Object)("Port: " + this.port)));
            this.notifyOutputListener((Serializable)((Object)("User DN: " + this.user)));
            this.notifyOutputListener((Serializable)((Object)("Base DN: " + this.baseDN)));
            this.notifyOutputListener((Serializable)((Object)("Authentication: " + this.auth)));
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.principal", this.user);
        env.put("java.naming.security.credentials", this.password);
        env.put("java.naming.security.authentication", this.auth);
        env.put("java.naming.provider.url", "ldap://" + this.host + ":" + this.port + "/" + this.baseDN);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        try {
            ctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw new ToolCommandException("Could not connect to the server.\nError: " + e.getMessage());
        }
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(this.scope);
        try {
            return ctx.search(this.exportPoint, "(objectClass=*)", ctls);
        }
        catch (NamingException e) {
            throw new ToolCommandException("Could not retreive entries");
        }
    }

    private void processParameters(Parameter[] params) {
        String hostParam;
        String installPathParam;
        Boolean verboseParam;
        Boolean debugParam;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < params.length; ++i) {
            Parameter parameter = params[i];
            parameters.put(parameter.getName(), parameter.getValue());
        }
        Boolean quietParam = (Boolean)parameters.get("quiet");
        if (quietParam != null) {
            this.setQuietEnabled(quietParam);
        }
        if ((debugParam = (Boolean)parameters.get("debug")) != null) {
            this.setDebugEnabled(debugParam);
        }
        if ((verboseParam = (Boolean)parameters.get("verbose")) != null) {
            this.setVerboseEnabled(verboseParam);
        }
        if ((installPathParam = (String)parameters.get("install-path")) != null) {
            try {
                this.setLayout(installPathParam);
                if (!this.isQuietEnabled()) {
                    this.notifyOutputListener((Serializable)((Object)("loading settings from: " + this.getLayout().getConfigurationFile())));
                }
                FileSystemXmlApplicationContext factory = null;
                URL configUrl = this.getLayout().getConfigurationFile().toURL();
                factory = new FileSystemXmlApplicationContext(configUrl.toString());
                this.setConfiguration((ServerStartupConfiguration)factory.getBean("configuration"));
            }
            catch (MalformedURLException e) {
                this.notifyErrorListener((Serializable)((Object)e.getMessage()));
                this.notifyExceptionListener(e);
            }
        }
        if ((hostParam = (String)parameters.get("host")) != null) {
            this.host = hostParam;
        } else {
            this.host = "localhost";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("host set to default: " + this.host)));
            }
        }
        Integer portParam = (Integer)parameters.get("port");
        if (portParam != null) {
            this.port = portParam;
        } else {
            this.port = 10389;
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("port set to default: " + this.port)));
            }
        }
        String userParam = (String)parameters.get("user");
        if (userParam != null) {
            this.user = userParam;
        } else {
            this.user = "uid=admin,ou=system";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("user set to default: " + this.user)));
            }
        }
        String passwordParam = (String)parameters.get("password");
        if (passwordParam != null) {
            this.password = passwordParam;
        } else {
            this.password = "secret";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("password set to default: " + this.password)));
            }
        }
        String authParam = (String)parameters.get("auth");
        if (authParam != null) {
            this.auth = authParam;
        } else {
            this.auth = "simple";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("authentication type set to default: " + this.auth)));
            }
        }
        String baseDNParam = (String)parameters.get(BASEDN_PARAMETER);
        if (baseDNParam != null) {
            this.baseDN = baseDNParam;
        } else {
            this.baseDN = "";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("base DN set to default: " + this.baseDN)));
            }
        }
        String exportPointParam = (String)parameters.get(EXPORTPOINT_PARAMETER);
        if (exportPointParam != null) {
            this.exportPoint = exportPointParam;
        } else {
            this.exportPoint = "";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("export point set to default: " + this.exportPoint)));
            }
        }
        String scopeParam = (String)parameters.get(SCOPE_PARAMETER);
        if (scopeParam != null) {
            if (scopeParam.equals(SCOPE_OBJECT)) {
                this.scope = 0;
            } else if (scopeParam.equals(SCOPE_ONELEVEL)) {
                this.scope = 1;
            } else if (scopeParam.equals(SCOPE_SUBTREE)) {
                this.scope = 2;
            }
        } else {
            this.scope = 2;
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("scope set to default: " + this.scope)));
            }
        }
        String ldifFileParam = (String)parameters.get(FILE_PARAMETER);
        if (ldifFileParam != null) {
            this.ldifFileName = ldifFileParam;
        }
    }

    private void processListeners(ListenerParameter[] listeners) {
        ToolCommandListener entryWrittenListener;
        ToolCommandListener exceptionListener;
        ToolCommandListener errorListener;
        HashMap<String, ToolCommandListener> parameters = new HashMap<String, ToolCommandListener>();
        for (int i = 0; i < listeners.length; ++i) {
            ListenerParameter parameter = listeners[i];
            parameters.put(parameter.getName(), parameter.getListener());
        }
        ToolCommandListener outputListener = (ToolCommandListener)parameters.get("ouputListener");
        if (outputListener != null) {
            this.outputListener = outputListener;
        }
        if ((errorListener = (ToolCommandListener)parameters.get("errorListener")) != null) {
            this.errorListener = errorListener;
        }
        if ((exceptionListener = (ToolCommandListener)parameters.get("exceptionListener")) != null) {
            this.exceptionListener = exceptionListener;
        }
        if ((entryWrittenListener = (ToolCommandListener)parameters.get(ENTRYWRITTENLISTENER_PARAMETER)) != null) {
            this.entryWrittenListener = entryWrittenListener;
        }
    }

    private void notifyEntryWrittenListener(Serializable o) {
        if (this.entryWrittenListener != null) {
            this.entryWrittenListener.notify(o);
        }
    }
}

