/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools.commands.exportcmd;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.directory.server.tools.commands.exportcmd.ExportCommandExecutorStub;
import org.apache.directory.server.tools.execution.ToolCommandExecutorStub;
import org.apache.directory.server.tools.request.BaseToolCommandCL;
import org.apache.directory.server.tools.util.Parameter;

public class ExportCommandCL
extends BaseToolCommandCL {
    private String ldifFileName;
    private String baseDN;
    private String exportPoint;
    private String scope;
    private static final String SCOPE_OBJECT = "object";
    private static final String SCOPE_ONELEVEL = "onelevel";
    private static final String SCOPE_SUBTREE = "subtree";

    public ExportCommandCL() {
        super("export");
    }

    public Options getOptions() {
        Options opts = new Options();
        Option op = new Option("h", "host", true, "server host: defaults to localhost");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("p", "port", true, "server port: defaults to 10389 or server.xml specified port");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("u", "user", true, "the user: default to uid=admin, ou=system");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("w", "password", true, "the apacheds administrator's password: defaults to secret");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("a", "auth", true, "the authentication mode: defaults to 'simple'");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("b", "base-dn", true, "the base DN: defaults to ''");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("e", "exportpoint", true, "the export point: defaults to ''");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("s", "scope", true, "the export scope ('object', 'onelevel' or 'subtree'): defaults to 'subtree'");
        op.setRequired(false);
        opts.addOption(op);
        op = new Option("f", "file", true, "the ldif file to export data to");
        op.setRequired(true);
        opts.addOption(op);
        return opts;
    }

    public ToolCommandExecutorStub getStub() {
        return new ExportCommandExecutorStub();
    }

    public void processOptions(CommandLine cmd) throws Exception {
        if (this.isDebugEnabled()) {
            System.out.println("Processing options for launching export ...");
        }
        if (cmd.hasOption('h')) {
            this.host = cmd.getOptionValue('h');
            if (this.isDebugEnabled()) {
                System.out.println("host overriden by -h option: true");
            }
            this.parameters.add(new Parameter("host", this.host));
        }
        if (cmd.hasOption('p')) {
            String val = cmd.getOptionValue('p');
            try {
                this.port = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("port value of '" + val + "' is not a number");
                System.exit(1);
            }
            if (this.port > 49151) {
                System.err.println("port value of '" + val + "' is larger than max port number: " + 49151);
                System.exit(1);
            } else if (this.port < 1) {
                System.err.println("port value of '" + val + "' is smaller than the minimum port number: " + 1);
                System.exit(1);
            }
            if (this.isDebugEnabled()) {
                System.out.println("port overriden by -p option: " + this.port);
            }
            this.parameters.add(new Parameter("port", new Integer(this.port)));
        }
        if (cmd.hasOption('u')) {
            this.user = cmd.getOptionValue('u');
            if (this.isDebugEnabled()) {
                System.out.println("user overriden by -u option: " + this.user);
            }
            this.parameters.add(new Parameter("user", this.user));
        }
        if (cmd.hasOption('w')) {
            this.password = cmd.getOptionValue('w');
            if (this.isDebugEnabled()) {
                System.out.println("password overriden by -w option: " + this.password);
            }
            this.parameters.add(new Parameter("password", this.password));
        }
        if (cmd.hasOption('a')) {
            this.auth = cmd.getOptionValue('a');
            if (this.isDebugEnabled()) {
                System.out.println("authentication type overriden by -a option: " + this.auth);
            }
            this.parameters.add(new Parameter("auth", this.auth));
        }
        if (cmd.hasOption('b')) {
            this.baseDN = cmd.getOptionValue('b');
            if (this.isDebugEnabled()) {
                System.out.println("base DN overriden by -b option: " + this.baseDN);
            }
            this.parameters.add(new Parameter("baseDN", this.baseDN));
        }
        if (cmd.hasOption('e')) {
            this.exportPoint = cmd.getOptionValue('e');
            if (this.isDebugEnabled()) {
                System.out.println("export point overriden by -e option: " + this.exportPoint);
            }
            this.parameters.add(new Parameter("exportPoint", this.exportPoint));
        }
        if (cmd.hasOption('s')) {
            this.scope = cmd.getOptionValue('s');
            if (this.scope.equals(SCOPE_OBJECT) || this.scope.equals(SCOPE_ONELEVEL) || this.scope.equals(SCOPE_SUBTREE)) {
                if (this.isDebugEnabled()) {
                    System.out.println("scope overriden by -s option: " + this.scope);
                }
            } else {
                System.err.println("unknown scope. Scope must be 'object', 'onelevel' or 'subtree'");
                System.exit(1);
            }
            this.parameters.add(new Parameter("scope", this.scope));
        }
        if (cmd.hasOption('f')) {
            this.ldifFileName = cmd.getOptionValue('f');
            if (this.ldifFileName == null || "".equals(this.ldifFileName)) {
                System.err.println("ldif file name must be provided");
                System.exit(1);
            }
            File ldifFile = new File(this.ldifFileName);
            if (this.isDebugEnabled()) {
                try {
                    System.out.println("ldif file to export entries to: " + ldifFile.getCanonicalPath());
                }
                catch (IOException ioe) {
                    System.out.println("ldif file to export entries to: " + ldifFile);
                }
            }
        } else {
            System.err.println("ldif file name must be provided");
            System.exit(1);
        }
        this.parameters.add(new Parameter("file", this.ldifFileName));
        this.parameters.add(new Parameter("debug", new Boolean(this.isDebugEnabled())));
        this.parameters.add(new Parameter("quiet", new Boolean(this.isQuietEnabled())));
        this.parameters.add(new Parameter("verbose", new Boolean(this.isVerboseEnabled())));
    }
}

