/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.directory.server.tools.BaseCommand;
import org.apache.directory.server.tools.listeners.ExceptionListener;
import org.apache.directory.server.tools.listeners.SysErrListener;
import org.apache.directory.server.tools.listeners.SysOutListener;
import org.apache.directory.server.tools.request.BaseToolCommandCL;
import org.apache.directory.server.tools.util.ListenerParameter;

public class ApachedsTools {
    public static void main(String[] args) {
        CommandLine cmdline;
        String command;
        SysOutListener outputListener = new SysOutListener();
        SysErrListener errorListener = new SysErrListener();
        ExceptionListener exceptionListener = new ExceptionListener();
        BaseCommand tools = null;
        try {
            tools = ApachedsTools.getInstance();
        }
        catch (Exception e) {
            System.err.println("An error has occurred. Apache DS Tools must quit.\nError: " + e.getMessage());
            System.exit(1);
        }
        if (!BaseCommand.hasBannerOption(args)) {
            tools.printBanner();
        }
        if (args.length == 0) {
            System.err.println("Type " + tools.getProductCommand() + " help for usage.");
            System.exit(1);
        }
        if ("help".equals(command = args[0].toLowerCase())) {
            CommandLine cmdline2 = tools.getCommandLine(command, args);
            if (cmdline2.getArgs().length > 1) {
                tools.helpOnCommand(cmdline2.getArgs()[1]);
                System.exit(0);
            } else {
                tools.printUsage();
                System.exit(0);
            }
        } else if (command.equals("-version")) {
            System.out.println(tools.getProductCommand() + " version " + tools.getProductVersion());
            System.exit(0);
        }
        BaseToolCommandCL cmd = (BaseToolCommandCL)tools.getCommands().get(command);
        if (cmd == null) {
            System.err.println("Unknown command: " + args[0]);
            System.err.println("Type " + tools.getProductCommand() + " help for usage.");
            System.exit(1);
        }
        if ((cmdline = tools.getCommandLine(command, args)).hasOption('d')) {
            cmd.setDebugEnabled(true);
            BaseCommand.dumpArgs("raw command line arguments: ", args);
            BaseCommand.dumpArgs("parsed arguments: ", cmdline.getArgs());
        }
        cmd.setQuietEnabled(cmdline.hasOption('q'));
        cmd.setDebugEnabled(cmdline.hasOption('d'));
        cmd.setVerboseEnabled(cmdline.hasOption('v'));
        cmd.setVersion(tools.getProductVersion());
        if (cmdline.hasOption('c') && cmdline.getOptionValue('i') == null) {
            System.err.println("forced configuration load (-c) requires the -i option");
            System.exit(1);
        }
        try {
            cmd.execute(cmdline, new ListenerParameter[]{new ListenerParameter("ouputListener", outputListener), new ListenerParameter("errorListener", errorListener), new ListenerParameter("exceptionListener", exceptionListener)});
        }
        catch (Exception e) {
            System.err.println("An error has occurred. Apache DS Tools must quit.\nError: " + e.getMessage());
            System.exit(1);
        }
    }

    public static BaseCommand getInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Properties props = new Properties();
        try {
            props.load(BaseCommand.class.getResourceAsStream("product.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String productVersion = props.getProperty("product.version", "UNKNOWN");
        String productUrl = props.getProperty("product.url", "http://directory.apache.org");
        String productDisplayName = props.getProperty("product.display.name", "Apache Directory Server");
        String productCommand = props.getProperty("product.command", "apacheds-tools");
        String productBanner = props.getProperty("product.banner", "       _                     _          ____  ____    _____           _      \n      / \\   _ __   __ _  ___| |__   ___|  _ \\/ ___|  |_   _|__   ___ | |___  \n     / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ | | \\___ \\    | |/ _ \\ / _ \\| / __| \n    / ___ \\| |_) | (_| | (__| | | |  __/ |_| |___) |   | | (_) | (_) | \\__ \\ \n   /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|____/|____/    |_|\\___/ \\___/|_|___/ \n           |_|                                                               \n");
        String productClass = props.getProperty("product.class", "org.apache.directory.server.tools.BaseCommand");
        BaseCommand baseCommand = (BaseCommand)Class.forName(productClass).newInstance();
        baseCommand.setProductBanner(productBanner);
        baseCommand.setProductDisplayName(productDisplayName);
        baseCommand.setProductUrl(productUrl);
        baseCommand.setProductVersion(productVersion);
        baseCommand.setProductCommand(productCommand);
        return baseCommand;
    }
}

