/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.io.NbMarshalledObject;

public abstract class ServiceType
implements Serializable,
HelpCtx.Provider {
    private static final long serialVersionUID = -7573598174423654252L;
    public static final String PROP_NAME = "name";
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.ServiceType");
    private String name;
    private transient PropertyChangeSupport supp;

    protected String displayName() {
        try {
            return Introspector.getBeanInfo(this.getClass()).getBeanDescriptor().getDisplayName();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, e);
            return this.getClass().getName();
        }
    }

    public final ServiceType createClone() {
        Exception anEx;
        block6: {
            if (this instanceof Cloneable) {
                try {
                    return (ServiceType)this.clone();
                }
                catch (CloneNotSupportedException ex) {
                    anEx = ex;
                    break block6;
                }
            }
            try {
                NbMarshalledObject m = new NbMarshalledObject(this);
                return (ServiceType)m.get();
            }
            catch (IOException ex) {
                anEx = ex;
            }
            catch (ClassNotFoundException ex) {
                anEx = ex;
            }
        }
        IllegalStateException ex = new IllegalStateException();
        ErrorManager err = ErrorManager.getDefault();
        err.copyAnnotation(ex, anEx);
        err.annotate((Throwable)ex, "Cannot createClone for " + this);
        throw ex;
    }

    protected Object clone() throws CloneNotSupportedException {
        ServiceType t = (ServiceType)super.clone();
        t.supp = null;
        t.name = null;
        return t;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        if (this.supp != null) {
            this.supp.firePropertyChange(PROP_NAME, old, name);
        }
    }

    public String getName() {
        return this.name == null ? this.displayName() : this.name;
    }

    @Override
    public abstract HelpCtx getHelpCtx();

    public final synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.supp == null) {
            this.supp = new PropertyChangeSupport(this);
        }
        this.supp.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.supp != null) {
            this.supp.removePropertyChangeListener(l);
        }
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        if (this.supp != null) {
            this.supp.firePropertyChange(name, o, n);
        }
    }

    public static final class Handle
    implements Serializable {
        static final long serialVersionUID = 7233109534462148872L;
        private String name;
        private String className;
        private transient ServiceType serviceType;

        public Handle(ServiceType ex) {
            this.name = ex.getName();
            this.className = ex.getClass().getName();
            this.serviceType = ex;
        }

        public ServiceType getServiceType() {
            if (this.serviceType == null) {
                Class<Object> serviceTypeClass;
                Class<Object> clazz;
                try {
                    clazz = Class.forName(this.className, true, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
                    serviceTypeClass = clazz;
                    while (serviceTypeClass.getSuperclass() != ServiceType.class) {
                        serviceTypeClass = serviceTypeClass.getSuperclass();
                    }
                }
                catch (ClassNotFoundException ex) {
                    err.log(1, "Service not found: " + ex.toString());
                    clazz = ServiceType.class;
                    serviceTypeClass = ServiceType.class;
                }
                Registry r = (Registry)Lookup.getDefault().lookup(Registry.class);
                Enumeration en = r.services(clazz);
                ServiceType some = r.find(clazz);
                while (en.hasMoreElements()) {
                    ServiceType t = (ServiceType)en.nextElement();
                    if (!serviceTypeClass.isInstance(t)) continue;
                    String n = t.getName();
                    if (n != null && n.equals(this.name)) {
                        return t;
                    }
                    if (some != null && (some.getClass() == clazz || t.getClass() != clazz)) continue;
                    some = t;
                }
                if (serviceTypeClass == ServiceType.class) {
                    return null;
                }
                return some;
            }
            return this.serviceType;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.name = (String)ois.readObject();
            String clazz = (String)ois.readObject();
            this.className = clazz == null ? null : Utilities.translate(clazz);
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.name);
            oos.writeObject(this.className);
        }

        public String toString() {
            return "Handle[" + this.className + ":" + this.name + "]";
        }
    }

    public static abstract class Registry
    implements Serializable {
        static final long serialVersionUID = 8721000770371416481L;

        public abstract Enumeration services();

        public Enumeration services(final Class clazz) {
            class IsInstance
            implements Enumerations.Processor {
                IsInstance() {
                }

                @Override
                public Object process(Object obj, Collection ignore) {
                    return clazz.isInstance(obj) ? obj : null;
                }
            }
            return Enumerations.filter(this.services(), new IsInstance());
        }

        public abstract List getServiceTypes();

        public abstract void setServiceTypes(List var1);

        public ServiceType find(Class clazz) {
            Enumeration en = this.services();
            while (en.hasMoreElements()) {
                Object o = en.nextElement();
                if (o.getClass() != clazz) continue;
                return (ServiceType)o;
            }
            return null;
        }

        public ServiceType find(String name) {
            Enumeration en = this.services();
            while (en.hasMoreElements()) {
                ServiceType o = (ServiceType)en.nextElement();
                if (!name.equals(o.getName())) continue;
                return o;
            }
            return null;
        }
    }
}

