/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public abstract class ActionsBridge {
    private static RequestProcessor RP = new RequestProcessor("Module-Actions", Integer.MAX_VALUE);

    protected abstract void invokeAction(Action var1, ActionEvent var2);

    public static void doPerformAction(CallableSystemAction action, final ActionRunnable r) {
        assert (EventQueue.isDispatchThread()) : "Action " + action.getClass().getName() + " may not be invoked from the thread " + Thread.currentThread().getName() + ", only the event queue: http://www.netbeans.org/download/4_1/javadoc/OpenAPIs/apichanges.html#actions-event-thread";
        if (r.async && !r.needsToBeSynchronous()) {
            Runnable r2 = new Runnable(){

                @Override
                public void run() {
                    r.doRun();
                }
            };
            RP.post(r2);
        } else {
            r.run();
        }
    }

    public static abstract class ActionRunnable
    implements Action {
        final ActionEvent ev;
        final SystemAction action;
        final boolean async;

        public ActionRunnable(ActionEvent ev, SystemAction action, boolean async) {
            this.ev = ev;
            this.action = action;
            this.async = async;
        }

        public final boolean needsToBeSynchronous() {
            return "waitFinished".equals(this.ev.getActionCommand());
        }

        public final void doRun() {
            ActionsBridge bridge = (ActionsBridge)Lookup.getDefault().lookup(ActionsBridge.class);
            if (bridge != null) {
                bridge.invokeAction(this, this.ev);
            } else {
                this.actionPerformed(this.ev);
            }
        }

        protected abstract void run();

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.run();
        }

        @Override
        public final void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object getValue(String key) {
            return this.action.getValue(key);
        }

        @Override
        public final boolean isEnabled() {
            return this.action.isEnabled();
        }

        @Override
        public final void putValue(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setEnabled(boolean b) {
            throw new UnsupportedOperationException();
        }
    }
}

