/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.EventObject;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

abstract class WeakListenerImpl
implements EventListener {
    private ListenerReference ref;
    Class listenerClass;
    private Reference source;

    protected WeakListenerImpl(Class listenerClass, EventListener l) {
        this.listenerClass = listenerClass;
        this.ref = new ListenerReference(l, this);
    }

    protected final void setSource(Object source) {
        this.source = source == null ? null : new WeakReference<Object>(source);
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject ev) {
        Object l = this.ref.get();
        if (l == null) {
            this.ref.requestCleanUp(ev == null ? null : ev.getSource());
        }
        return (EventListener)l;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Object listener = this.ref.get();
        return this.getClass().getName() + "[" + (listener == null ? "null" : listener.getClass().getName() + "]");
    }

    public static EventListener create(Class lType, Class apiType, EventListener l, Object source) {
        ProxyListener pl = new ProxyListener(lType, apiType, l);
        pl.setSource(source);
        return (EventListener)pl.proxy;
    }

    private static final class ListenerReference
    extends WeakReference
    implements Runnable {
        private static Class lastClass;
        private static String lastMethodName;
        private static Method lastRemove;
        private static Object LOCK;
        WeakListenerImpl weakListener;

        public ListenerReference(Object ref, WeakListenerImpl weakListener) {
            super(ref, Utilities.activeReferenceQueue());
            this.weakListener = weakListener;
        }

        public synchronized void requestCleanUp(Object source) {
            if (this.weakListener == null) {
                return;
            }
            if (this.weakListener.source != source) {
                this.weakListener.source = new WeakReference(source){
                    ListenerReference doNotGCRef;
                    {
                        super(x0);
                        this.doNotGCRef = new ListenerReference(new Object(), weakListener);
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WeakListenerImpl ref;
            Object[] params = new Object[1];
            Class[] types = new Class[1];
            Object src = null;
            Method remove = null;
            ListenerReference listenerReference = this;
            synchronized (listenerReference) {
                block18: {
                    block17: {
                        ref = this.weakListener;
                        if (ref.source == null) break block17;
                        Object t = ref.source.get();
                        src = t;
                        if (t != null) break block18;
                    }
                    return;
                }
                this.weakListener = null;
            }
            Class<?> methodClass = src.getClass();
            String methodName = ref.removeMethodName();
            Object object = LOCK;
            synchronized (object) {
                if (lastClass == methodClass && lastMethodName == methodName && lastRemove != null) {
                    remove = lastRemove;
                }
            }
            if (remove == null) {
                types[0] = ref.listenerClass;
                remove = this.getRemoveMethod(methodClass, methodName, types[0]);
                if (remove == null) {
                    ErrorManager.getDefault().log(16, "Can't remove " + ref.listenerClass.getName() + " using method " + methodName + " from " + src);
                    return;
                }
                object = LOCK;
                synchronized (object) {
                    lastClass = methodClass;
                    lastMethodName = methodName;
                    lastRemove = remove;
                }
            }
            params[0] = ref.getImplementator();
            try {
                remove.invoke(src, params);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, "Problem encountered while calling " + methodClass + "." + methodName + "(...) on " + src);
                ErrorManager.getDefault().notify(1, ex);
            }
        }

        private Method getRemoveMethod(Class methodClass, String methodName, Class listenerClass) {
            Class[] clarray = new Class[]{listenerClass};
            Method m = null;
            try {
                m = methodClass.getMethod(methodName, clarray);
            }
            catch (NoSuchMethodException e) {
                do {
                    try {
                        m = methodClass.getDeclaredMethod(methodName, clarray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    methodClass = methodClass.getSuperclass();
                } while (m == null && methodClass != Object.class);
            }
            if (!(m == null || Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers()))) {
                m.setAccessible(true);
            }
            return m;
        }

        static {
            LOCK = new Object();
        }
    }

    private static class ProxyListener
    extends WeakListenerImpl
    implements InvocationHandler {
        private static Method equalsMth;
        private static final WeakHashMap constructors;
        public final Object proxy;

        public ProxyListener(Class c, Class api, EventListener listener) {
            super(api, listener);
            try {
                Object p;
                Constructor<?> proxyConstructor;
                Reference ref = (Reference)constructors.get(c);
                Constructor<?> constructor = proxyConstructor = ref == null ? null : (Constructor<?>)ref.get();
                if (proxyConstructor == null) {
                    Class<?> proxyClass = Proxy.getProxyClass(c.getClassLoader(), c);
                    proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
                    constructors.put(c, new SoftReference(proxyConstructor));
                }
                try {
                    p = proxyConstructor.newInstance(this);
                }
                catch (NoClassDefFoundError err) {
                    p = Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)this);
                }
                this.proxy = p;
            }
            catch (Exception ex) {
                IllegalStateException e = new IllegalStateException(ex.getMessage());
                ErrorManager.getDefault().annotate((Throwable)e, ex);
                throw e;
            }
        }

        private static Method getEquals() {
            if (equalsMth == null) {
                try {
                    equalsMth = Object.class.getMethod("equals", Object.class);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            return equalsMth;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method == ProxyListener.getEquals()) {
                    boolean ret = this.equals(args[0]);
                    return ret ? Boolean.TRUE : Boolean.FALSE;
                }
                return method.invoke((Object)this, args);
            }
            EventObject ev = args != null && args[0] instanceof EventObject ? (EventObject)args[0] : null;
            EventListener listener = super.get(ev);
            if (listener != null) {
                return method.invoke((Object)listener, args);
            }
            return null;
        }

        @Override
        protected String removeMethodName() {
            String name = this.listenerClass.getName();
            int dot = name.lastIndexOf(46);
            int i = (name = name.substring(dot + 1)).lastIndexOf(36);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            return "remove".concat(name);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.listenerClass + "]";
        }

        public boolean equals(Object obj) {
            return this.proxy == obj || this == obj;
        }

        @Override
        Object getImplementator() {
            return this.proxy;
        }

        static {
            constructors = new WeakHashMap();
        }
    }

    static final class Focus
    extends WeakListenerImpl
    implements FocusListener {
        public Focus(FocusListener l) {
            super(FocusListener.class, l);
        }

        @Override
        public void focusGained(FocusEvent ev) {
            FocusListener l = (FocusListener)super.get(ev);
            if (l != null) {
                l.focusGained(ev);
            }
        }

        @Override
        public void focusLost(FocusEvent ev) {
            FocusListener l = (FocusListener)super.get(ev);
            if (l != null) {
                l.focusLost(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeFocusListener";
        }
    }

    static final class Change
    extends WeakListenerImpl
    implements ChangeListener {
        public Change(ChangeListener l) {
            super(ChangeListener.class, l);
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            ChangeListener l = (ChangeListener)super.get(ev);
            if (l != null) {
                l.stateChanged(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeChangeListener";
        }
    }

    static final class Document
    extends WeakListenerImpl
    implements DocumentListener {
        public Document(DocumentListener l) {
            super(DocumentListener.class, l);
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.changedUpdate(ev);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.insertUpdate(ev);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.removeUpdate(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent ev) {
            DocumentListener l = (DocumentListener)((WeakListenerImpl)this).ref.get();
            if (l == null) {
                ((WeakListenerImpl)this).ref.requestCleanUp(ev.getDocument());
            }
            return l;
        }
    }

    static class VetoableChange
    extends WeakListenerImpl
    implements VetoableChangeListener {
        public VetoableChange(VetoableChangeListener l) {
            super(VetoableChangeListener.class, l);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            VetoableChangeListener l = (VetoableChangeListener)super.get(ev);
            if (l != null) {
                l.vetoableChange(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }
    }

    static class PropertyChange
    extends WeakListenerImpl
    implements PropertyChangeListener {
        public PropertyChange(PropertyChangeListener l) {
            super(PropertyChangeListener.class, l);
        }

        PropertyChange(Class clazz, PropertyChangeListener l) {
            super(clazz, l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            PropertyChangeListener l = (PropertyChangeListener)super.get(ev);
            if (l != null) {
                l.propertyChange(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }
    }
}

