/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;

final class ArrayStorage
implements AbstractLookup.Storage {
    static final Integer DEFAULT_TRASH = new Integer(11);
    private Object content;
    private transient AbstractLookup.ReferenceToResult results;

    public ArrayStorage() {
        this(DEFAULT_TRASH);
    }

    public ArrayStorage(Integer treshhold) {
        this.content = treshhold;
    }

    @Override
    public boolean add(AbstractLookup.Pair item, Object transaction) {
        Transaction changed = (Transaction)transaction;
        Object[] arr = changed.current;
        if (changed.arr == null) {
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] == null) {
                    arr[i] = item;
                    changed.add(item);
                    return true;
                }
                if (!arr[i].equals(item)) continue;
                item.setIndex(null, ((AbstractLookup.Pair)arr[i]).getIndex());
                arr[i] = item;
                return false;
            }
            throw new IllegalStateException();
        }
        int newIndex = changed.addPair(item);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null) {
                changed.add(item);
                return true;
            }
            if (!arr[i].equals(item)) continue;
            if (i != newIndex) {
                changed.add(item);
                return false;
            }
            return false;
        }
        changed.add(item);
        return true;
    }

    @Override
    public void remove(AbstractLookup.Pair item, Object transaction) {
        Transaction changed = (Transaction)transaction;
        Object[] arr = changed.current;
        int found = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null) {
                return;
            }
            if (found != -1 || !arr[i].equals(item)) continue;
            ((AbstractLookup.Pair)arr[i]).setIndex(null, -1);
            changed.add(arr[i]);
            found = i;
            if (found == -1) continue;
            if (i < arr.length) {
                arr[i - 1] = arr[i];
                continue;
            }
            arr[i - 1] = null;
        }
    }

    @Override
    public void retainAll(Map retain, Object transaction) {
        Transaction changed = (Transaction)transaction;
        Object[] arr = changed.current;
        for (int from = 0; from < arr.length && arr[from] instanceof AbstractLookup.Pair; ++from) {
            AbstractLookup.Pair p = (AbstractLookup.Pair)arr[from];
            AbstractLookup.Info info = (AbstractLookup.Info)retain.get(p);
            if (info != null) continue;
            changed.add(p);
        }
    }

    @Override
    public Enumeration lookup(final Class clazz) {
        if (this.content instanceof Object[]) {
            Enumeration all = Enumerations.array((Object[])this.content);
            class CheckEn
            implements Enumerations.Processor {
                CheckEn() {
                }

                @Override
                public Object process(Object o, Collection ignore) {
                    boolean ok = o instanceof AbstractLookup.Pair ? clazz == null || ((AbstractLookup.Pair)o).instanceOf(clazz) : false;
                    return ok ? o : null;
                }
            }
            return Enumerations.filter(all, new CheckEn());
        }
        return Enumerations.empty();
    }

    @Override
    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult newRef) {
        AbstractLookup.ReferenceToResult prev = this.results;
        this.results = newRef;
        return prev;
    }

    @Override
    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template templ) {
        AbstractLookup.ReferenceIterator it = new AbstractLookup.ReferenceIterator(this.results);
        while (it.next()) {
        }
        this.results = it.first();
        return this.results;
    }

    @Override
    public Object beginTransaction(int ensure) {
        return new Transaction(ensure, this.content);
    }

    @Override
    public void endTransaction(Object transaction, Set modified) {
        Transaction changed = (Transaction)transaction;
        AbstractLookup.ReferenceIterator it = new AbstractLookup.ReferenceIterator(this.results);
        if (changed.arr == null) {
            while (it.next()) {
                AbstractLookup.ReferenceToResult ref = it.current();
                for (AbstractLookup.Pair p : changed) {
                    if (!AbstractLookup.matches(ref.template, p, true)) continue;
                    modified.add(ref.getResult());
                }
            }
        } else {
            block2: while (it.next()) {
                AbstractLookup.ReferenceToResult ref = it.current();
                int oldIndex = -1;
                int newIndex = -1;
                do {
                    oldIndex = ArrayStorage.findMatching(ref.template, changed.current, oldIndex);
                    newIndex = ArrayStorage.findMatching(ref.template, changed.arr, newIndex);
                    if (oldIndex == -1 && newIndex == -1) continue block2;
                } while (oldIndex != -1 && newIndex != -1 && changed.current[oldIndex].equals(changed.arr[newIndex]));
                modified.add(ref.getResult());
            }
        }
        this.results = it.first();
        this.content = changed.newContent();
    }

    private static int findMatching(Lookup.Template t, Object[] arr, int from) {
        while (++from < arr.length) {
            if (!(arr[from] instanceof AbstractLookup.Pair) || !AbstractLookup.matches(t, (AbstractLookup.Pair)arr[from], true)) continue;
            return from;
        }
        return -1;
    }

    private static final class Transaction
    extends HashSet {
        public final Object[] current;
        public final Object[] arr;
        private int cnt;

        public Transaction(int ensure, Object currentContent) {
            int maxSize;
            Object[] arr;
            Integer trashold;
            if (currentContent instanceof Integer) {
                trashold = (Integer)currentContent;
                arr = null;
            } else {
                arr = (Object[])currentContent;
                trashold = arr[arr.length - 1] instanceof Integer ? (Integer)arr[arr.length - 1] : null;
            }
            int n = maxSize = trashold == null ? arr.length : trashold;
            if (ensure > maxSize) {
                throw new UnsupportedOperationException();
            }
            if (ensure == -1) {
                this.current = (Object[])currentContent;
                this.arr = null;
                return;
            }
            if (ensure == -2) {
                if (arr == null) {
                    arr = new Object[2];
                    arr[1] = trashold;
                } else {
                    if (arr[arr.length - 1] instanceof AbstractLookup.Pair) {
                        throw new UnsupportedOperationException();
                    }
                    if (arr[arr.length - 2] != null) {
                        int newSize = (arr.length - 1) * 2;
                        if (newSize > maxSize) {
                            newSize = maxSize;
                            if (newSize <= arr.length) {
                                throw new UnsupportedOperationException();
                            }
                            arr = new Object[newSize];
                        } else {
                            arr = new Object[newSize + 1];
                            arr[newSize] = trashold;
                        }
                        System.arraycopy(currentContent, 0, arr, 0, ((Object[])currentContent).length - 1);
                    }
                }
                this.current = arr;
                this.arr = null;
            } else {
                if (ensure == maxSize) {
                    this.arr = new Object[ensure];
                } else {
                    this.arr = new Object[ensure + 1];
                    this.arr[ensure] = trashold;
                }
                this.current = currentContent instanceof Object[] ? (Object[])currentContent : new Object[]{};
            }
        }

        public int addPair(AbstractLookup.Pair p) {
            p.setIndex(null, this.cnt);
            this.arr[this.cnt++] = p;
            return p.getIndex();
        }

        public Object newContent() {
            return this.arr == null ? this.current : this.arr;
        }
    }
}

