/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.ArrayStorage;
import org.openide.util.lookup.InheritanceTree;

final class DelegatingStorage
implements Serializable,
AbstractLookup.Storage {
    private AbstractLookup.Storage delegate;
    private Thread owner;

    public DelegatingStorage(AbstractLookup.Storage d) {
        this.delegate = d;
        this.owner = Thread.currentThread();
    }

    public Object writeReplace() {
        return this.delegate;
    }

    public void checkForTreeModification() {
        if (Thread.currentThread() == this.owner) {
            throw new AbstractLookup.ISE("You are trying to modify lookup from lookup query!");
        }
    }

    public static boolean isSimple(AbstractLookup.Storage s) {
        if (s instanceof DelegatingStorage) {
            return ((DelegatingStorage)s).delegate instanceof ArrayStorage;
        }
        return s instanceof ArrayStorage;
    }

    public AbstractLookup.Storage exitDelegate() {
        if (Thread.currentThread() != this.owner) {
            throw new IllegalStateException("Onwer: " + this.owner + " caller: " + Thread.currentThread());
        }
        AbstractLookup.Storage d = this.delegate;
        this.delegate = null;
        return d;
    }

    @Override
    public boolean add(AbstractLookup.Pair item, Object transaction) {
        return this.delegate.add(item, transaction);
    }

    @Override
    public void remove(AbstractLookup.Pair item, Object transaction) {
        this.delegate.remove(item, transaction);
    }

    @Override
    public void retainAll(Map retain, Object transaction) {
        this.delegate.retainAll(retain, transaction);
    }

    @Override
    public Object beginTransaction(int ensure) {
        try {
            return this.delegate.beginTransaction(ensure);
        }
        catch (UnsupportedOperationException ex) {
            ArrayStorage arr = (ArrayStorage)this.delegate;
            this.delegate = new InheritanceTree();
            Enumeration en = arr.lookup(Object.class);
            while (en.hasMoreElements()) {
                if (this.delegate.add((AbstractLookup.Pair)en.nextElement(), new ArrayList())) continue;
                throw new IllegalStateException("All objects have to be accepted");
            }
            AbstractLookup.ReferenceToResult ref = arr.cleanUpResult(null);
            if (ref != null) {
                ref.cloneList(this.delegate);
            }
            return this.delegate.beginTransaction(ensure);
        }
    }

    @Override
    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template templ) {
        return this.delegate.cleanUpResult(templ);
    }

    @Override
    public void endTransaction(Object transaction, Set modified) {
        this.delegate.endTransaction(transaction, modified);
    }

    @Override
    public Enumeration lookup(Class clazz) {
        return this.delegate.lookup(clazz);
    }

    @Override
    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult newRef) {
        return this.delegate.registerReferenceToResult(newRef);
    }
}

