/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.Arrays;
import java.util.Collections;
import org.openide.util.Lookup;
import org.openide.util.lookup.ExcludingLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.MetaInfServicesLookup;
import org.openide.util.lookup.SimpleLookup;
import org.openide.util.lookup.SimpleProxyLookup;

public class Lookups {
    private Lookups() {
    }

    public static Lookup singleton(Object objectToLookup) {
        if (objectToLookup == null) {
            throw new NullPointerException();
        }
        return new SimpleLookup(Collections.singleton(objectToLookup));
    }

    public static Lookup fixed(Object[] objectsToLookup) {
        if (objectsToLookup == null) {
            throw new NullPointerException();
        }
        return new SimpleLookup(Arrays.asList(objectsToLookup));
    }

    public static Lookup fixed(Object[] keys, InstanceContent.Convertor convertor) {
        if (keys == null) {
            throw new NullPointerException();
        }
        if (convertor == null) {
            throw new NullPointerException();
        }
        return new SimpleLookup(Arrays.asList(keys), convertor);
    }

    public static Lookup proxy(Lookup.Provider provider) {
        return new SimpleProxyLookup(provider);
    }

    public static Lookup metaInfServices(ClassLoader classLoader) {
        return new MetaInfServicesLookup(classLoader);
    }

    public static Lookup exclude(Lookup lookup, Class[] classes) {
        return new ExcludingLookup(lookup, classes);
    }

    public static Lookup.Item lookupItem(Object instance, String id) {
        return new LookupItem(instance, id);
    }

    private static class LookupItem
    extends Lookup.Item {
        private String id;
        private Object instance;

        public LookupItem(Object instance) {
            this(instance, null);
        }

        public LookupItem(Object instance, String id) {
            this.id = id;
            this.instance = instance;
        }

        @Override
        public String getDisplayName() {
            return this.getId();
        }

        @Override
        public String getId() {
            return this.id == null ? this.instance.toString() : this.id;
        }

        @Override
        public Object getInstance() {
            return this.instance;
        }

        @Override
        public Class getType() {
            return this.instance.getClass();
        }

        public boolean equals(Object object) {
            if (object instanceof LookupItem) {
                return this.instance == ((LookupItem)object).getInstance();
            }
            return false;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }
    }
}

