/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class SimpleLookup
extends Lookup {
    private Collection allItems;

    SimpleLookup(Collection instances) {
        this.allItems = new ArrayList(instances.size());
        Iterator i = instances.iterator();
        while (i.hasNext()) {
            this.allItems.add(new InstanceContent.SimpleItem(i.next()));
        }
    }

    SimpleLookup(Collection keys, InstanceContent.Convertor conv) {
        this.allItems = new ArrayList(keys.size());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            this.allItems.add(new InstanceContent.ConvertingItem(i.next(), conv));
        }
    }

    public String toString() {
        return "SimpleLookup" + this.lookup(new Lookup.Template(Object.class)).allInstances();
    }

    @Override
    public Lookup.Result lookup(Lookup.Template template) {
        if (template == null) {
            throw new NullPointerException();
        }
        return new SimpleResult(template);
    }

    @Override
    public Object lookup(Class clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return item == null ? null : item.getInstance();
    }

    private static boolean matches(Lookup.Template t, AbstractLookup.Pair item) {
        if (!AbstractLookup.matches(t, item, true)) {
            return false;
        }
        Class type = t.getType();
        return type == null || type.isAssignableFrom(item.getType());
    }

    private class SimpleResult
    extends Lookup.Result {
        private Set classes;
        private Collection items;
        private Lookup.Template template;
        private Collection results;

        SimpleResult(Lookup.Template template) {
            this.template = template;
        }

        @Override
        public void addLookupListener(LookupListener l) {
        }

        @Override
        public void removeLookupListener(LookupListener l) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection allInstances() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.results != null) {
                    return this.results;
                }
            }
            ArrayList<Object> res = new ArrayList<Object>(SimpleLookup.this.allItems.size());
            Iterator i = this.allItems().iterator();
            while (i.hasNext()) {
                res.add(((Lookup.Item)i.next()).getInstance());
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.results = Collections.unmodifiableCollection(res);
            }
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set allClasses() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.classes != null) {
                    return this.classes;
                }
            }
            HashSet<Class> res = new HashSet<Class>();
            Iterator i = this.allItems().iterator();
            while (i.hasNext()) {
                res.add(((Lookup.Item)i.next()).getType());
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.classes = Collections.unmodifiableSet(res);
            }
            return this.classes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection allItems() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.items != null) {
                    return this.items;
                }
            }
            ArrayList res = new ArrayList(SimpleLookup.this.allItems.size());
            for (Object o : SimpleLookup.this.allItems) {
                if (!(o instanceof AbstractLookup.Pair) || !SimpleLookup.matches(this.template, (AbstractLookup.Pair)o)) continue;
                res.add(o);
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.items = Collections.unmodifiableCollection(res);
            }
            return this.items;
        }
    }
}

