/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLUtil {
    private static boolean useFastSAXParserFactory = true;
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Class fastParserFactoryClass = null;
    private static final ThreadLocal[] builderTL = new ThreadLocal[4];
    private static final String IDENTITY_XSLT_WITH_INDENT = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>";

    private XMLUtil() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        return XMLUtil.createXMLReader(false, false);
    }

    public static XMLReader createXMLReader(boolean validate) throws SAXException {
        return XMLUtil.createXMLReader(validate, false);
    }

    public static XMLReader createXMLReader(boolean validate, boolean namespaceAware) throws SAXException {
        SAXParserFactory factory;
        if (!validate && useFastSAXParserFactory) {
            try {
                factory = XMLUtil.createFastSAXParserFactory();
            }
            catch (ParserConfigurationException ex) {
                factory = SAXParserFactory.newInstance();
            }
            catch (SAXException ex) {
                factory = SAXParserFactory.newInstance();
            }
        } else {
            useFastSAXParserFactory = false;
            factory = SAXParserFactory.newInstance();
        }
        factory.setValidating(validate);
        factory.setNamespaceAware(namespaceAware);
        try {
            return factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", ex);
        }
    }

    public static Document createDocument(String rootQName, String namespaceURI, String doctypePublicID, String doctypeSystemID) throws DOMException {
        DOMImplementation impl = XMLUtil.getDOMImplementation();
        if (doctypePublicID != null && doctypeSystemID == null) {
            throw new IllegalArgumentException("System ID cannot be null if public ID specified. ");
        }
        DocumentType dtd = null;
        if (doctypeSystemID != null) {
            dtd = impl.createDocumentType(rootQName, doctypePublicID, doctypeSystemID);
        }
        return impl.createDocument(namespaceURI, rootQName, dtd);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException ex) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
        catch (RuntimeException e) {
            throw (DOMException)new DOMException(9, e.toString()).initCause(e);
        }
    }

    public static Document parse(InputSource input, boolean validate, boolean namespaceAware, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        int index = (validate ? 0 : 1) + (namespaceAware ? 0 : 2);
        DocumentBuilder builder = (DocumentBuilder)builderTL[index].get();
        if (builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(namespaceAware);
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException("Cannot create parser satisfying configuration parameters", ex);
            }
            builderTL[index].set(builder);
        }
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        return builder.parse(input);
    }

    public static void write(Document doc, OutputStream out, String enc) throws IOException {
        if (enc == null) {
            throw new NullPointerException("You must set an encoding; use \"UTF-8\" unless you have a good reason not to!");
        }
        Document doc2 = XMLUtil.normalize(doc);
        if (System.getProperty("java.specification.version").startsWith("1.4")) {
            try {
                XMLUtil.writeXerces(doc2, out, enc);
                return;
            }
            catch (ClassNotFoundException e) {
                throw (IOException)new IOException("You need to have xerces.jar available to use XMLUtil.write under JDK 1.4: " + e).initCause(e);
            }
            catch (Exception e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
        }
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        ClassLoader global = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        ClassLoader target = XMLUtil.class.getClassLoader();
        if (global == null) {
            global = target;
        }
        try {
            Class<?> clazz = global.loadClass("org.netbeans.core.startup.SAXFactoryImpl");
            if (clazz != null) {
                target = clazz.getClassLoader();
            }
        }
        catch (Exception clazz) {
            // empty catch block
        }
        Thread.currentThread().setContextClassLoader(target);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(IDENTITY_XSLT_WITH_INDENT)));
            DocumentType dt = doc2.getDoctype();
            if (dt != null) {
                String pub = dt.getPublicId();
                if (pub != null) {
                    t.setOutputProperty("doctype-public", pub);
                }
                t.setOutputProperty("doctype-system", dt.getSystemId());
            }
            t.setOutputProperty("encoding", enc);
            DOMSource source = new DOMSource(doc2);
            StreamResult result = new StreamResult(out);
            t.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    private static void writeXerces(Document doc, OutputStream out, String encoding) throws ClassNotFoundException, Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> xmlSerializerClazz = Class.forName("org.apache.xml.serialize.XMLSerializer", true, cl);
        Class<?> outputFormatClazz = Class.forName("org.apache.xml.serialize.OutputFormat", true, cl);
        Object xmlSerializer = xmlSerializerClazz.newInstance();
        Object outputFormat = outputFormatClazz.newInstance();
        Method setMethod = outputFormatClazz.getMethod("setMethod", String.class);
        setMethod.invoke(outputFormat, "xml");
        Method setIndenting = outputFormatClazz.getMethod("setIndenting", Boolean.TYPE);
        setIndenting.invoke(outputFormat, Boolean.TRUE);
        Method setLineWidth = outputFormatClazz.getMethod("setLineWidth", Integer.TYPE);
        setLineWidth.invoke(outputFormat, new Integer(0));
        Method setLineSeparator = outputFormatClazz.getMethod("setLineSeparator", String.class);
        setLineSeparator.invoke(outputFormat, (Object[])new String[]{System.getProperty("line.separator")});
        Method setOutputByteStream = xmlSerializerClazz.getMethod("setOutputByteStream", OutputStream.class);
        setOutputByteStream.invoke(xmlSerializer, out);
        Method setEncoding = outputFormatClazz.getMethod("setEncoding", String.class);
        setEncoding.invoke(outputFormat, encoding);
        Method setOutputFormat = xmlSerializerClazz.getMethod("setOutputFormat", outputFormatClazz);
        setOutputFormat.invoke(xmlSerializer, outputFormat);
        Method setNamespaces = xmlSerializerClazz.getMethod("setNamespaces", Boolean.TYPE);
        setNamespaces.invoke(xmlSerializer, Boolean.TRUE);
        Method asDOMSerializer = xmlSerializerClazz.getMethod("asDOMSerializer", new Class[0]);
        Object impl = asDOMSerializer.invoke(xmlSerializer, null);
        Method serialize = impl.getClass().getMethod("serialize", Document.class);
        serialize.invoke(impl, doc);
    }

    public static String toAttributeValue(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(val)) {
            return val;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if ('<' == ch) {
                buf.append("&lt;");
                continue;
            }
            if ('&' == ch) {
                buf.append("&amp;");
                continue;
            }
            if ('\'' == ch) {
                buf.append("&apos;");
                continue;
            }
            if ('\"' == ch) {
                buf.append("&quot;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String toElementContent(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(val)) {
            return val;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if ('<' == ch) {
                buf.append("&lt;");
                continue;
            }
            if ('&' == ch) {
                buf.append("&amp;");
                continue;
            }
            if ('>' == ch && i > 1 && val.charAt(i - 2) == ']' && val.charAt(i - 1) == ']') {
                buf.append("&gt;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String toHex(byte[] val, int start, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            byte b = val[start + i];
            buf.append(DEC2HEX[(b & 0xF0) >> 4]);
            buf.append(DEC2HEX[b & 0xF]);
        }
        return buf.toString();
    }

    public static byte[] fromHex(char[] hex, int start, int len) throws IOException {
        if (hex == null) {
            throw new IOException("null");
        }
        int i = hex.length;
        if (i % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] magic = new byte[i / 2];
        while (i > 0) {
            String g = new String(hex, i - 2, 2);
            try {
                magic[i / 2 - 1] = (byte)Integer.parseInt(g, 16);
            }
            catch (NumberFormatException ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
            i -= 2;
        }
        return magic;
    }

    private static boolean checkAttributeCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        block4: for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            if (ch > ']') continue;
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    escape = true;
                    continue block4;
                }
                default: {
                    if (ch >= ' ') continue block4;
                    throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                }
            }
        }
        return !escape;
    }

    private static boolean checkContentCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        block5: for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            if (ch > ']') continue;
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block5;
                }
                case '>': {
                    if (escape) continue block5;
                    escape = i > 0 && chars.charAt(i - 1) == ']';
                    continue block5;
                }
                case '&': 
                case '<': {
                    escape = true;
                    continue block5;
                }
                default: {
                    if (ch >= ' ') continue block5;
                    throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                }
            }
        }
        return !escape;
    }

    private static SAXParserFactory createFastSAXParserFactory() throws ParserConfigurationException, SAXException {
        block6: {
            if (fastParserFactoryClass == null) {
                try {
                    fastParserFactoryClass = Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                }
                catch (Exception ex) {
                    useFastSAXParserFactory = false;
                    if (!System.getProperty("java.version").startsWith("1.4")) break block6;
                    ErrorManager.getDefault().notify(1, ex);
                }
            }
        }
        if (fastParserFactoryClass != null) {
            try {
                SAXParserFactory factory = (SAXParserFactory)fastParserFactoryClass.newInstance();
                return factory;
            }
            catch (Exception ex) {
                useFastSAXParserFactory = false;
                throw new ParserConfigurationException(ex.getMessage());
            }
        }
        return SAXParserFactory.newInstance();
    }

    private static Document normalize(Document orig) throws IOException {
        int i;
        Document doc;
        DocumentBuilder builder = (DocumentBuilder)builderTL[0].get();
        if (builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException("Cannot create parser satisfying configuration parameters: " + e).initCause(e);
            }
            builderTL[0].set(builder);
        }
        DocumentType doctype = null;
        NodeList nl = orig.getChildNodes();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            if (!(nl.item(i2) instanceof DocumentType)) continue;
            doctype = (DocumentType)nl.item(i2);
        }
        if (doctype != null) {
            doc = builder.getDOMImplementation().createDocument(orig.getDocumentElement().getNamespaceURI(), orig.getDocumentElement().getTagName(), builder.getDOMImplementation().createDocumentType(orig.getDoctype().getName(), orig.getDoctype().getPublicId(), orig.getDoctype().getSystemId()));
            doc.removeChild(doc.getDocumentElement());
        } else {
            doc = builder.newDocument();
        }
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i) instanceof DocumentType) continue;
            doc.appendChild(doc.importNode(nl.item(i), true));
        }
        doc.normalize();
        nl = doc.getElementsByTagName("*");
        for (i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            NodeList nl2 = e.getChildNodes();
            for (int j = 0; j < nl2.getLength(); ++j) {
                Node n = nl2.item(j);
                if (!(n instanceof Text) || ((Text)n).getNodeValue().trim().length() != 0) continue;
                e.removeChild(n);
                --j;
            }
        }
        return doc;
    }

    static {
        for (int i = 0; i < 4; ++i) {
            XMLUtil.builderTL[i] = new ThreadLocal();
        }
    }
}

