/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.modules.openide.util.AWTBridge;
import org.netbeans.modules.openide.util.ActionsBridge;
import org.openide.ErrorManager;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public abstract class CallbackSystemAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final String PROP_ACTION_PERFORMER = "actionPerformer";
    private static final WeakSet notSurviving = new WeakSet(37);
    private static final WeakSet surviving = new WeakSet(37);
    private static final Object LISTENER = new Object();
    static final long serialVersionUID = -6305817805474624653L;
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.util.actions.CallbackSystemAction");
    private static final boolean errLog = err.isLoggable(1);

    @Override
    protected void initialize() {
        super.initialize();
        this.updateEnabled();
        this.setSurviveFocusChange(false);
    }

    public ActionPerformer getActionPerformer() {
        return (ActionPerformer)this.getProperty(PROP_ACTION_PERFORMER);
    }

    public void setActionPerformer(ActionPerformer performer) {
        this.putProperty(PROP_ACTION_PERFORMER, performer);
        this.updateEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEnabled() {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            this.setEnabled(action.isEnabled());
            Object object = LISTENER;
            synchronized (object) {
                ActionDelegateListener l = (ActionDelegateListener)this.getProperty(LISTENER);
                if (l == null || l.get() != this) {
                    l = new ActionDelegateListener(this, action);
                    this.putProperty(LISTENER, l);
                } else {
                    l.attach(action);
                }
            }
        } else {
            if (this.getActionPerformer() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.clearListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListener() {
        Object object = LISTENER;
        synchronized (object) {
            ActionDelegateListener l = (ActionDelegateListener)this.getProperty(LISTENER);
            if (l != null) {
                l.clear();
                this.putProperty(LISTENER, null);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            if (action.isEnabled()) {
                action.actionPerformed(ev);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return;
        }
        final ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ActionsBridge.doPerformAction(this, new ActionsBridge.ActionRunnable(ev, this, this.asynchronous()){

                @Override
                public void run() {
                    ap.performAction(CallbackSystemAction.this);
                }
            });
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void performAction() {
        ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ap.performAction(this);
        }
    }

    public Object getActionMapKey() {
        return this.getClass().getName();
    }

    public boolean getSurviveFocusChange() {
        this.getProperty(null);
        return !notSurviving.contains(this.getClass());
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurviveFocusChange(boolean b) {
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            if (b) {
                notSurviving.remove(this.getClass());
                surviving.add(this.getClass());
            } else {
                notSurviving.add(this.getClass());
                surviving.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList toInstances(Set s) {
        ArrayList<SharedClassObject> actions;
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            actions = new ArrayList<SharedClassObject>(s.size());
            for (Class c : s) {
                SharedClassObject a = SystemAction.findObject(c, false);
                if (a == null) continue;
                actions.add(a);
            }
        }
        return actions;
    }

    private static void clearActionPerformers() {
        ArrayList actions = CallbackSystemAction.toInstances(notSurviving);
        for (CallbackSystemAction a : actions) {
            a.setActionPerformer(null);
        }
        actions = CallbackSystemAction.toInstances(surviving);
        for (CallbackSystemAction a : actions) {
            if (errLog) {
                err.log("updateEnabled: " + a);
            }
            a.updateEnabled();
        }
    }

    private static final class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    PropertyChangeListener {
        private CallbackSystemAction delegate;
        private Lookup.Result result;
        private boolean enabled;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private PropertyChangeListener weakL;
        private WeakReference lastRef;

        public DelegateAction(CallbackSystemAction a, Lookup actionContext) {
            this.delegate = a;
            this.weakL = WeakListeners.propertyChange(this, null);
            this.enabled = a.getActionPerformer() != null;
            this.result = actionContext.lookup(new Lookup.Template(ActionMap.class));
            this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            final Action a = this.findAction();
            if (a != null) {
                ActionsBridge.ActionRunnable run = new ActionsBridge.ActionRunnable(e, this.delegate, this.delegate.asynchronous()){

                    @Override
                    public void run() {
                        a.actionPerformed(e);
                    }
                };
                ActionsBridge.doPerformAction(this.delegate, run);
            } else {
                Object value;
                Object source = e.getSource();
                if (source instanceof Component && SwingUtilities.getWindowAncestor((Component)source) instanceof Dialog && !Boolean.TRUE.equals(value = this.delegate.getValue("OpenIDE-Transmodal-Action"))) {
                    return;
                }
                this.delegate.actionPerformed(e);
            }
        }

        @Override
        public boolean isEnabled() {
            Action last;
            Action a = this.findAction();
            if (a == null) {
                a = this.delegate;
            }
            Action action = last = this.lastRef == null ? null : (Action)this.lastRef.get();
            if (a != last) {
                if (last != null) {
                    last.removePropertyChangeListener(this.weakL);
                }
                this.lastRef = new WeakReference<Action>(a);
                a.addPropertyChangeListener(this.weakL);
            }
            return a.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        @Override
        public void putValue(String key, Object o) {
        }

        @Override
        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            boolean newEnabled = this.isEnabled();
            if (newEnabled != this.enabled) {
                this.support.firePropertyChange("enabled", this.enabled, newEnabled);
                this.enabled = newEnabled;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.resultChanged(null);
        }

        private Action findAction() {
            List c;
            Collection collection = c = this.result != null ? this.result.allInstances() : Collections.EMPTY_LIST;
            if (!c.isEmpty()) {
                Object key = this.delegate.getActionMapKey();
                for (ActionMap map : c) {
                    Action action = map.get(key);
                    if (action == null) continue;
                    return action;
                }
            }
            return null;
        }

        @Override
        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverriden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return AWTBridge.getDefault().createMenuPresenter(this);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverriden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return AWTBridge.getDefault().createPopupPresenter(this);
        }

        @Override
        public Component getToolbarPresenter() {
            if (this.isMethodOverriden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return AWTBridge.getDefault().createToolbarPresenter(this);
        }

        private boolean isMethodOverriden(CallableSystemAction d, String name) {
            try {
                Method m = d.getClass().getMethod(name, new Class[0]);
                return m.getDeclaringClass() != CallableSystemAction.class;
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Error searching for method " + name + " in " + d);
            }
        }

        protected void finalize() {
            Action last;
            Action action = last = this.lastRef == null ? null : (Action)this.lastRef.get();
            if (last != null) {
                last.removePropertyChangeListener(this.weakL);
            }
        }
    }

    private static final class ActionDelegateListener
    extends WeakReference
    implements PropertyChangeListener {
        private WeakReference delegate;

        public ActionDelegateListener(CallbackSystemAction c, Action delegate) {
            super(c);
            this.delegate = new WeakReference<Action>(delegate);
            delegate.addPropertyChangeListener(this);
        }

        @Override
        public void clear() {
            Action a;
            WeakReference d = this.delegate;
            Action action = a = d == null ? null : (Action)d.get();
            if (a == null) {
                return;
            }
            this.delegate = null;
            a.removePropertyChangeListener(this);
        }

        public void attach(Action action) {
            WeakReference d = this.delegate;
            if (d != null && d.get() == action) {
                return;
            }
            Action prev = (Action)d.get();
            if (prev != null) {
                prev.removePropertyChangeListener(this);
            }
            this.delegate = new WeakReference<Action>(action);
            action.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object object = LISTENER;
            synchronized (object) {
                WeakReference d = this.delegate;
                if (d == null || d.get() == null) {
                    return;
                }
            }
            CallbackSystemAction c = (CallbackSystemAction)this.get();
            if (c != null) {
                c.updateEnabled();
            }
        }
    }

    private static final class WeakAction
    extends WeakReference
    implements Action {
        public WeakAction(Action delegate) {
            super(delegate);
        }

        public Action getDelegate() {
            return (Action)super.get();
        }

        @Override
        public Object getValue(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putValue(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEnabled(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEnabled() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GlobalManager
    implements LookupListener {
        private static GlobalManager instance;
        private Lookup.Result result;
        private Reference actionMap = new WeakReference<Object>(null);
        private final ActionMap survive = new ActionMap();

        private GlobalManager() {
            this.result = Utilities.actionsGlobalContext().lookup(new Lookup.Template(ActionMap.class));
            this.result.addLookupListener(this);
            this.resultChanged(null);
        }

        public static synchronized GlobalManager getDefault() {
            if (instance != null) {
                return instance;
            }
            instance = new GlobalManager();
            return instance;
        }

        public Action findGlobalAction(Object key, boolean surviveFocusChange) {
            Action a;
            ActionMap map = (ActionMap)this.actionMap.get();
            Action action = a = map == null ? null : map.get(key);
            if (surviveFocusChange) {
                if (a == null) {
                    a = this.survive.get(key);
                    if (a != null) {
                        a = ((WeakAction)a).getDelegate();
                    }
                    if (errLog) {
                        err.log("No action for key: " + key + " using delegate: " + a);
                    }
                } else {
                    if (errLog) {
                        err.log("New action for key: " + key + " put: " + a);
                    }
                    this.survive.put(key, new WeakAction(a));
                }
            }
            if (errLog) {
                err.log("Action for key: " + key + " is: " + a);
            }
            return a;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            ActionMap a = (ActionMap)Utilities.actionsGlobalContext().lookup(ActionMap.class);
            if (errLog) {
                err.log("changed map : " + a);
                err.log("previous map: " + this.actionMap.get());
            }
            if (a == this.actionMap.get()) {
                return;
            }
            this.actionMap = new WeakReference<ActionMap>(a);
            if (errLog) {
                err.log("clearActionPerformers");
            }
            CallbackSystemAction.clearActionPerformers();
        }
    }
}

