/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.io.SafeException;

public class NbObjectInputStream
extends ObjectInputStream {
    public NbObjectInputStream(InputStream is) throws IOException {
        super(is);
        try {
            this.enableResolveObject(true);
        }
        catch (SecurityException ex) {
            throw new IOException(ex.toString());
        }
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        ClassLoader cl = NbObjectInputStream.getNBClassLoader();
        try {
            return Class.forName(v.getName(), false, cl);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "Offending classloader: " + cl;
            ErrorManager.getDefault().annotate(cnfe, 1, msg, null, null, null);
            throw cnfe;
        }
    }

    private static ClassLoader getNBClassLoader() {
        ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        return c != null ? c : ClassLoader.getSystemClassLoader();
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        String newN;
        ObjectStreamClass ose = super.readClassDescriptor();
        String name = ose.getName();
        if (name == (newN = Utilities.translate(name))) {
            return ose;
        }
        ClassLoader cl = NbObjectInputStream.getNBClassLoader();
        Class<?> clazz = Class.forName(newN, false, cl);
        ObjectStreamClass newOse = ObjectStreamClass.lookup(clazz);
        if (newOse == null) {
            throw new NotSerializableException(newN);
        }
        return newOse;
    }

    public static Object readSafely(ObjectInput oi) throws IOException {
        int size = oi.readInt();
        byte[] byteArray = new byte[size];
        oi.readFully(byteArray, 0, size);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
            NbObjectInputStream ois = new NbObjectInputStream(bis);
            Object obj = ois.readObject();
            bis.close();
            return obj;
        }
        catch (Exception exc) {
            throw new SafeException(exc);
        }
        catch (LinkageError le) {
            throw new SafeException(new InvocationTargetException(le));
        }
    }

    public static void skipSafely(ObjectInput oi) throws IOException {
        int size = oi.readInt();
        oi.skip(size);
    }
}

