/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends Profile
implements AssociatedObjectsProvider {
    private static final long serialVersionUID = 1L;
    private Set<ApplicationGroup> applicationGroups;
    private Set<Application> applications;
    private Set<Printer> printers;
    private Set<Device> devices;
    private HardwareType hardwareType;
    private String ipAddress;
    private String macAddress;
    private Location location;

    public Set<ApplicationGroup> getApplicationGroups() {
        return this.applicationGroups;
    }

    public Set<Application> getApplications() {
        return this.applications;
    }

    public String getIpHostNumber() {
        if (null == this.ipAddress) {
            return "0.0.0.0";
        }
        return this.ipAddress;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setApplicationGroups(Set<ApplicationGroup> applicationGroups) {
        this.applicationGroups = applicationGroups;
    }

    public void setApplications(Set<Application> applications) {
        this.applications = applications;
    }

    public void setHardwareType(HardwareType hardwareType) {
        this.hardwareType = hardwareType;
        this.firePropertyChange("hardwareType", null, hardwareType);
    }

    public HardwareType getHardwareType() {
        return this.hardwareType;
    }

    @Deprecated
    public void setHwTypes(Set<HardwareType> hardwareType) {
        this.hardwareType = hardwareType.size() > 0 ? hardwareType.iterator().next() : null;
    }

    @Deprecated
    public Set<HardwareType> getHwTypes() {
        HashSet<HardwareType> set = new HashSet<HardwareType>();
        if (null != this.hardwareType) {
            set.add(this.hardwareType);
        }
        return set;
    }

    public void setIpHostNumber(String ipHostNumber) {
        String oldIpAddress = this.ipAddress;
        this.ipAddress = ipHostNumber;
        this.firePropertyChange("ipHostNumber", oldIpAddress, ipHostNumber);
    }

    public void setLocation(Location location) {
        this.location = location;
        this.firePropertyChange("location", null, location);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[Client name=").append(this.getName()).append(", description=").append(this.getDescription()).append(", ip=").append(this.ipAddress).append(", location=").append(this.location).append(" applicationGroups={");
        if (this.applicationGroups != null) {
            for (ApplicationGroup g : this.applicationGroups) {
                sb.append(g).append(" ");
            }
            sb.append("}, applications={");
        }
        if (this.applications != null) {
            for (Application a : this.applications) {
                sb.append(a).append(" ");
            }
            sb.append("}]");
        }
        return sb.toString();
    }

    public Set<Printer> getPrinters() {
        return this.printers;
    }

    public void setPrinters(Set<Printer> printers) {
        this.printers = printers;
        this.firePropertyChange("printers", null, printers);
    }

    public Set<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(Set<Device> devices) {
        this.devices = devices;
        this.firePropertyChange("devices", null, devices);
    }

    @Override
    public Map<Class, Set<? extends DirectoryObject>> getAssociatedObjects() {
        HashMap<Class, Set<? extends DirectoryObject>> assocObjects = new HashMap<Class, Set<? extends DirectoryObject>>();
        assocObjects.put(Application.class, this.applications);
        assocObjects.put(ApplicationGroup.class, this.applicationGroups);
        assocObjects.put(Printer.class, this.printers);
        assocObjects.put(Device.class, this.devices);
        return assocObjects;
    }

    @Override
    public void setAssociatedObjects(Class subgroupClass, Set<? extends DirectoryObject> subgroups) {
        if (subgroupClass.equals(Application.class)) {
            this.setApplications(subgroups);
        }
        if (subgroupClass.equals(ApplicationGroup.class)) {
            this.setApplicationGroups(subgroups);
        }
        if (subgroupClass.equals(Printer.class)) {
            this.setPrinters(subgroups);
        }
        if (subgroupClass.equals(Device.class)) {
            this.setDevices(subgroups);
        }
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        String oldMacAddress = this.macAddress;
        this.macAddress = macAddress.toLowerCase();
        this.firePropertyChange("macAddress", oldMacAddress, macAddress);
    }

    @Override
    protected Profile[] getInheritedProfiles() {
        return new Profile[]{this.hardwareType, this.location, this.getRealm()};
    }
}

