/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Properties;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;

public abstract class Profile
extends DirectoryObject {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_SCHEMA_VERSION = "schema_version";
    public static final String WARNING_REMOVED_OPTION = "WARNING_REMOVED_OPTION";
    public static final String WARNING_NEW_FIELD = "WARNING_NEW_FIELD";
    private transient Schema schema;
    private transient Properties properties;
    private final transient Map<String, String> warnings = new HashMap<String, String>();

    public String getValue(String key) {
        String myValue = this.getValueLocal(key);
        if (null != myValue) {
            return myValue;
        }
        return this.getInheritedValue(key);
    }

    public String getValueLocal(String key) {
        return (String)this.getProperties().getMap().get(key);
    }

    private String getInheritedValue(String key) {
        String value = null;
        for (Profile inherited : this.getInheritedProfiles()) {
            if (null == inherited || null == (value = inherited.getValueLocal(key))) continue;
            return value;
        }
        if (null != this.schema) {
            value = this.schema.getValue(key);
        }
        if (null != value) {
            return value;
        }
        for (Profile inherited : this.getInheritedProfiles()) {
            if (null == inherited || inherited.getName().equals(this.getName()) || null == (value = inherited.getInheritedValue(key))) continue;
            return value;
        }
        return null;
    }

    protected Profile[] getInheritedProfiles() {
        Profile[] none = new Profile[]{};
        return none;
    }

    public void setValue(String path, String value) {
        this.getProperties().getMap().put(path, value);
    }

    public void removeValue(String key) {
        this.getProperties().getMap().remove(key);
    }

    public boolean containsValue(String key) {
        return null != this.properties && this.getProperties().getMap().containsKey(key);
    }

    public boolean inherits(String key) {
        Profile[] inheritedProfiles = this.getInheritedProfiles();
        return inheritedProfiles != null;
    }

    public String getOverriddenValue(String key) {
        return this.getInheritedValue(key);
    }

    public String getDefiningProfile(String path, boolean excludeThis) {
        if (!excludeThis && this.containsValue(path)) {
            return this.getName();
        }
        for (Profile inherited : this.getInheritedProfiles()) {
            if (null == inherited || !inherited.containsValue(path)) continue;
            return inherited.getName();
        }
        if (this.schema.contains(path)) {
            return "Schema '" + this.schema.getName() + "'";
        }
        for (Profile inherited : this.getInheritedProfiles()) {
            String definingProfile;
            if (null == inherited || null == (definingProfile = inherited.getDefiningProfile(path, excludeThis))) continue;
            return definingProfile;
        }
        return null;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
        if (schema != null) {
            this.setValue(PROPERTY_SCHEMA_VERSION, String.valueOf(schema.getVersion()));
            this.getProperties().setDescription(schema.getName());
        }
    }

    public Schema getSchema(Realm realm) throws SchemaLoadingException {
        if (null == this.schema) {
            this.loadSchema(realm);
        }
        return this.schema;
    }

    public void initSchemas(Realm realm) throws SchemaLoadingException {
        if (null == this.schema) {
            this.loadSchema(realm);
        }
        for (Profile inherited : this.getInheritedProfiles()) {
            if (null == inherited) continue;
            inherited.initSchemas(realm);
        }
    }

    private void loadSchema(Realm realm) throws SchemaLoadingException {
        String schemaName = this.getSchemaName();
        this.schema = realm.getSchemaProvider().getSchema(this.getClass(), schemaName);
        if (null == this.schema) {
            throw new SchemaLoadingException("Schema wasn't found for " + this.getClass() + (null != schemaName ? ", schemaName=" + schemaName : ""));
        }
        String propertiesVersion = this.getValue(PROPERTY_SCHEMA_VERSION);
        String schemaVersion = String.valueOf(this.schema.getVersion());
        if (propertiesVersion == null || !propertiesVersion.equals(schemaVersion)) {
            HashSet<String> set = new HashSet<String>();
            for (String propertyName : this.getProperties().getMap().keySet()) {
                if (this.schema.getNodeForPath(propertyName) != null) continue;
                this.warnings.put(propertyName, WARNING_REMOVED_OPTION);
                set.add(propertyName);
            }
            for (String propertyName : set) {
                this.getProperties().getMap().remove(propertyName);
            }
            this.setValue(PROPERTY_SCHEMA_VERSION, String.valueOf(this.schema.getVersion()));
        }
    }

    protected String getSchemaName() {
        return this.getProperties().getDescription();
    }

    @Deprecated
    public final void setProperties(Properties props) {
        this.properties = props;
    }

    @Deprecated
    public final Properties getProperties() {
        if (null == this.properties) {
            this.properties = new Properties("profile", "unknown", new TreeMap<String, String>());
        }
        return this.properties;
    }

    public String getWarning(String key) {
        return this.warnings.get(key);
    }
}

