/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.openthinclient.common.model.schema.EntryNode;
import org.openthinclient.common.model.schema.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceNode
extends EntryNode {
    private static final long serialVersionUID = 983752831232339241L;
    private final List<Option> options = new ArrayList<Option>();
    private Style style;

    public ChoiceNode(String name, String value) {
        super(name, value);
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public Option getSelectedOption() {
        String value = this.getValue();
        for (Option o : this.options) {
            if (!o.getValue().equals(value)) continue;
            return o;
        }
        return null;
    }

    public String getLabelForValue(String value) {
        if (null != value) {
            for (Option option : this.getOptions()) {
                if (!value.equals(option.getValue())) continue;
                return option.getLabel();
            }
        }
        return "";
    }

    protected void toStringExtended(int indent, StringBuffer sb) {
        for (Option option : this.options) {
            for (int j = 0; j < indent; ++j) {
                sb.append("  ");
            }
            sb.append("[Option: ").append(option.getName()).append(" -> ").append(option.getValue()).append("]\n");
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setStyle(String style) {
        this.style = Style.valueOf(style);
    }

    @Override
    public long getUID() {
        long uid = 0L;
        for (Option opt : this.options) {
            uid ^= (long)opt.getValue().hashCode();
        }
        return super.getUID() ^ uid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        COMBOBOX,
        LIST,
        LIST_MULTI,
        CHECKBOXES,
        RADIOBUTTONS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Option
    implements Serializable {
        private static final long serialVersionUID = 83274659873458345L;
        private String name;
        private String value;
        private ArrayList<Label> labels;

        public Option(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.getLabel();
        }

        public ArrayList<Label> getLabels() {
            return this.labels;
        }

        public void setLabels(ArrayList<Label> labels) {
            this.labels = labels;
        }

        public String getLabel() {
            if (this.labels != null) {
                for (Label label : this.labels) {
                    if (!label.getLang().equals(Locale.getDefault().getLanguage())) continue;
                    String labelText = label.getLabel();
                    Logger.getLogger(this.getClass()).debug((Object)labelText);
                    if (labelText == null) continue;
                    return labelText;
                }
            }
            return this.getName();
        }
    }
}

