/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.openthinclient.common.model.schema.Label;
import org.openthinclient.common.model.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements Iterable<Node>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final List<Node> EMPTY_COLLECTION = new LinkedList<Node>();
    private String name;
    private transient Node parent;
    private transient String key;
    private List<Node> children = EMPTY_COLLECTION;
    private ArrayList<Label> labels = new ArrayList();
    private ArrayList<Label> tips = new ArrayList();

    public Node(String name) {
        this.name = name;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public Node getChild(String name) {
        for (Node child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public void addChild(Node child) {
        if (this.children == EMPTY_COLLECTION) {
            this.children = new ArrayList<Node>();
        }
        child.setParent(this);
        this.children.add(child);
    }

    protected void addChild(Node child, int index) {
        if (this.children == EMPTY_COLLECTION) {
            this.children = new ArrayList<Node>();
        }
        child.setParent(this);
        this.children.add(index, child);
    }

    public boolean removeChild(Node child) {
        if (!this.children.contains(child)) {
            return false;
        }
        child.setParent(null);
        this.children.remove(child);
        return true;
    }

    public String getName() {
        return this.name;
    }

    public Node getParent() {
        return this.parent;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
        this.clearPathCache();
    }

    @Deprecated
    public void clearPathCache() {
        if (null != this.key) {
            this.key = null;
            for (Node child : this.children) {
                child.clearPathCache();
            }
        }
    }

    public String getKey() {
        if (null == this.key) {
            this.key = null == this.parent || this.parent instanceof Schema ? this.name : this.parent.getKey() + "." + this.name;
        }
        return this.key;
    }

    public String toString() {
        return this.getLabel();
    }

    public void removeAllChildren() {
        this.children = EMPTY_COLLECTION;
    }

    public void setName(String name) {
        if (name.contains("/")) {
            throw new IllegalArgumentException("Node name may not contain a '/'");
        }
        this.name = name;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.children.iterator();
    }

    public ArrayList<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(ArrayList<Label> labels) {
        this.labels = labels;
    }

    public String getLabel() {
        for (Label label : this.labels) {
            String labelText;
            if (!label.getLang().equals(Locale.getDefault().getLanguage()) || (labelText = label.getLabel()) == null) continue;
            return labelText;
        }
        return this.name;
    }

    public ArrayList<Label> getTips() {
        return this.tips;
    }

    public void setTips(ArrayList<Label> tips) {
        this.tips = tips;
    }

    public String getTip() {
        for (Label tip : this.tips) {
            if (!tip.getLang().equals(Locale.getDefault().getLanguage())) continue;
            return tip.getLabel();
        }
        return null;
    }

    protected long getUID() {
        long uid = this.getClass().getSimpleName().hashCode();
        for (Node child : this.children) {
            uid ^= child.getUID();
        }
        return uid ^= (long)(this.getKey().hashCode() ^ this.getName().hashCode());
    }
}

