/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema;

import java.text.Collator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.EntryNode;
import org.openthinclient.common.model.schema.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema<T extends Profile>
extends Node
implements Comparable<Schema> {
    private static final long serialVersionUID = 109860938274823423L;
    private Class type = Application.class;
    private final boolean singleInstanceOnly;
    private final String subtype;

    public Schema(String name) {
        super(name);
        this.subtype = null;
        this.singleInstanceOnly = false;
    }

    public Schema getSchema() {
        return this;
    }

    public boolean contains(String key) {
        return null != this.getNodeForPath(key);
    }

    public Node getNodeForPath(String path) {
        Node node = this;
        StringTokenizer st = new StringTokenizer(path, ".");
        if (st.hasMoreTokens()) {
            String nodeName = st.nextToken();
            if (nodeName.equals(node.getName()) && st.hasMoreTokens()) {
                nodeName = st.nextToken();
            }
            do {
                node = node.getChild(nodeName);
                if (!st.hasMoreTokens()) break;
                nodeName = st.nextToken();
            } while (node != null);
            return node;
        }
        return null;
    }

    public Set<String> getKeys() {
        return null;
    }

    public String getOverriddenValue(String key) {
        return null;
    }

    public String getValue(String key) {
        Node n = this.getNodeForPath(key);
        return null != n && n instanceof EntryNode ? ((EntryNode)n).getValue() : null;
    }

    public Map<String, String> getValues() {
        return null;
    }

    public void setValue(String path, String value) {
        throw new IllegalArgumentException("Can't set the value here.");
    }

    public void setValues(SortedMap<String, String> values) {
        throw new IllegalArgumentException("Can't set the value here.");
    }

    public boolean isSingleInstanceOnly() {
        return this.singleInstanceOnly;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public long getVersion() {
        return this.getUID();
    }

    @Override
    public int compareTo(Schema compareSchema) {
        Collator collator = Collator.getInstance();
        return collator.compare(this.getLabel(), compareSchema.getLabel());
    }
}

