/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Unmarshaller;
import org.openthinclient.common.model.schema.Node;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaProvider
implements SchemaProvider {
    private static final Logger logger = Logger.getLogger(AbstractSchemaProvider.class);
    protected final String SCHEMA_PATH = "schema";
    protected Map<String, Map<String, Schema>> typeCache = new HashMap<String, Map<String, Schema>>();
    private Mapping mapping;

    @Override
    public Schema getSchema(Class profileType, String schemaName) throws SchemaLoadingException {
        try {
            String profileTypeName = profileType.getName().toLowerCase();
            profileTypeName = profileTypeName.substring(profileTypeName.lastIndexOf(46) + 1);
            if (!this.typeCache.containsKey(profileTypeName)) {
                this.getSchemaNames(profileType);
            }
            Map<String, Schema> schemas = this.typeCache.get(profileTypeName);
            if (null != schemaName && schemas.containsKey(schemaName)) {
                return schemas.get(schemaName);
            }
            return schemas.get(profileTypeName);
        }
        catch (Exception e) {
            logger.error((Object)("Schema couldn't be loaded! " + e));
            return null;
        }
    }

    private Mapping getMapping() throws IOException, MappingException {
        if (null == this.mapping) {
            this.mapping = new Mapping();
            this.mapping.loadMapping(new InputSource(Node.class.getResourceAsStream("schema-mapping.xml")));
        }
        return this.mapping;
    }

    @Override
    public String[] getSchemaNames(Class profileType) throws SchemaLoadingException {
        Object schemas;
        String profileTypeName = profileType.getName().toLowerCase();
        if (!this.typeCache.containsKey(profileTypeName = profileTypeName.substring(profileTypeName.lastIndexOf(46) + 1))) {
            schemas = new ArrayList<Schema>();
            schemas.addAll(this.loadAllSchemas(profileTypeName));
            schemas.addAll(this.loadDefaultSchema(profileTypeName));
            Map<String, Schema> schemasByName = this.typeCache.get(profileTypeName);
            if (null == schemasByName) {
                schemasByName = new HashMap<String, Schema>();
                this.typeCache.put(profileTypeName, schemasByName);
            }
            Iterator i$ = schemas.iterator();
            while (i$.hasNext()) {
                Schema schema = (Schema)i$.next();
                schemasByName.put(schema.getName(), schema);
            }
        }
        if (null == (schemas = this.typeCache.get(profileTypeName))) {
            logger.error((Object)("No schemas found for " + profileType));
            return new String[0];
        }
        String[] keys = new String[schemas.keySet().size()];
        return schemas.keySet().toArray(keys);
    }

    protected abstract List<Schema> loadDefaultSchema(String var1) throws SchemaLoadingException;

    protected abstract List<Schema> loadAllSchemas(String var1) throws SchemaLoadingException;

    protected Schema loadSchema(InputStream is) throws SchemaLoadingException {
        try {
            Mapping mapping = this.getMapping();
            InputSource source = new InputSource(is);
            Unmarshaller unmarshaller = new Unmarshaller();
            unmarshaller.setMapping(mapping);
            return (Schema)unmarshaller.unmarshal(source);
        }
        catch (Exception e) {
            throw new SchemaLoadingException("Schema couldn't be loaded!", e);
        }
    }

    public void reload() {
        this.typeCache = new HashMap<String, Map<String, Schema>>();
    }
}

