/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema.provider;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.AbstractSchemaProvider;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger logger = Logger.getLogger(HTTPSchemaProvider.class);
    private final URL baseURL;

    public HTTPSchemaProvider(String hostname) throws MalformedURLException {
        this.baseURL = new URL("http", hostname, 8080, "/openthinclient/files/schema/");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using schema base url: " + this.baseURL));
        }
    }

    public boolean checkAccess() {
        try {
            URLConnection openConnection = this.baseURL.openConnection();
            String contentType = openConnection.getContentType();
            return contentType.startsWith("text/plain;");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected List<Schema> loadDefaultSchema(String profileTypeName) throws SchemaLoadingException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try {
            this.loadFromURL(schemas, new URL(this.baseURL, profileTypeName + ".xml"));
        }
        catch (Throwable e) {
            throw new SchemaLoadingException("Could not fetch schema from file service", e);
        }
        return schemas;
    }

    private void loadFromURL(List<Schema> schemas, URL url) throws IOException, SchemaLoadingException {
        URLConnection con;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to load schema from " + url));
        }
        if ((con = url.openConnection()).getContentType().startsWith("application/octet-stream")) {
            schemas.add(this.loadSchema(con.getInputStream()));
        }
    }

    @Override
    protected List<Schema> loadAllSchemas(String profileTypeName) throws SchemaLoadingException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try {
            String line;
            URL dirURL = new URL(this.baseURL, profileTypeName + "/");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to load all schemas for " + profileTypeName + " from " + dirURL));
            }
            URLConnection con = dirURL.openConnection();
            InputStream inputStream = con.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
            while ((line = br.readLine()) != null) {
                String filename;
                if (!line.startsWith("F") || !(filename = line.substring(2)).endsWith(".xml")) continue;
                this.loadFromURL(schemas, new URL(dirURL, filename));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No schemas found for " + profileTypeName));
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Could not fetch schema from file service", e);
            throw new SchemaLoadingException("Could not fetch schema from file service", e);
        }
        return schemas;
    }

    @Override
    public void reload() {
        super.reload();
        try {
            this.loadAllSchemas("application");
        }
        catch (SchemaLoadingException e) {
            e.printStackTrace();
        }
    }
}

