/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema.provider;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.AbstractSchemaProvider;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLocalSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger logger = Logger.getLogger(ServerLocalSchemaProvider.class);
    private final File basedir = new File(System.getProperty("jboss.server.data.dir"), "nfs" + File.separator + "root" + File.separator + "schema");

    public ServerLocalSchemaProvider() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using schema base dir: " + this.basedir));
        }
    }

    @Override
    protected List<Schema> loadDefaultSchema(String profileTypeName) throws SchemaLoadingException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try {
            this.loadFromFile(schemas, new File(this.basedir, profileTypeName + ".xml"));
        }
        catch (Throwable e) {
            throw new SchemaLoadingException("Could not fetch schema from file service", e);
        }
        return schemas;
    }

    private void loadFromFile(List<Schema> schemas, File f) throws IOException, SchemaLoadingException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to load schema from " + f));
        }
        if (f.exists() && f.canRead()) {
            schemas.add(this.loadSchema(new FileInputStream(f)));
        }
    }

    @Override
    protected List<Schema> loadAllSchemas(String profileTypeName) throws SchemaLoadingException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try {
            File[] files;
            File dir = new File(this.basedir, profileTypeName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to load all schemas for " + profileTypeName + " from " + dir));
            }
            if (null != (files = dir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isFile() && f.canRead() && f.getName().endsWith(".xml");
                }
            }))) {
                for (int i = 0; i < files.length; ++i) {
                    File f = files[i];
                    this.loadFromFile(schemas, f);
                }
            }
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No schemas found for " + profileTypeName));
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Could not fetch schema from file service", e);
            throw new SchemaLoadingException("Could not fetch schema from file service", e);
        }
        return schemas;
    }
}

