/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.log4j.Logger;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.UnmodifiableHashtable;
import org.openthinclient.ldap.auth.CachingCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryFacade {
    private static final Logger logger = Logger.getLogger(DirectoryFacade.class);
    private String baseDN;
    private Name baseDNName;
    private LDAPConnectionDescriptor.DirectoryType directoryType;
    private Hashtable<Object, Object> ldapEnvironment;
    private NameParser nameParser;
    private final LDAPConnectionDescriptor connectionDescriptor;
    private String dummyDN;

    DirectoryFacade(LDAPConnectionDescriptor lcd) {
        this.connectionDescriptor = new LDAPConnectionDescriptor(lcd);
    }

    public Name getBaseDNName() throws NamingException {
        if (null == this.baseDNName) {
            this.baseDNName = this.getNameParser().parse(this.connectionDescriptor.getBaseDN());
        }
        return this.baseDNName;
    }

    public String getBaseDN() {
        if (null == this.baseDN) {
            this.baseDN = this.connectionDescriptor.getBaseDN();
        }
        return this.baseDN;
    }

    public Hashtable<Object, Object> getLDAPEnv() throws NamingException {
        if (null == this.ldapEnvironment) {
            Hashtable<Object, Object> env = new Hashtable<Object, Object>(this.connectionDescriptor.getExtraEnv());
            this.populateDefaultEnv(env);
            switch (this.connectionDescriptor.getConnectionMethod()) {
                case PLAIN: {
                    env.put("java.naming.security.authentication", "none");
                    break;
                }
                case SSL: {
                    env.put("java.naming.security.protocol", "ssl");
                    break;
                }
                case START_TLS: {
                    throw new IllegalArgumentException("Start TLS not yet supported");
                }
            }
            switch (this.connectionDescriptor.getAuthenticationMethod()) {
                case NONE: {
                    env.put("java.naming.security.authentication", "none");
                    break;
                }
                case SIMPLE: {
                    env.put("java.naming.security.authentication", "simple");
                    NameCallback nc = new NameCallback("Bind DN");
                    PasswordCallback pc = new PasswordCallback("Password", false);
                    try {
                        this.connectionDescriptor.getCallbackHandler().handle(new Callback[]{nc, pc});
                    }
                    catch (Exception e) {
                        throw new NamingException("Can't get authentication information: " + e);
                    }
                    env.put("java.naming.security.principal", nc.getName());
                    env.put("java.naming.security.credentials", new String(pc.getPassword()).getBytes());
                    break;
                }
                case SASL: {
                    throw new IllegalArgumentException("SASL not yet supported");
                }
            }
            env.put("java.naming.provider.url", this.connectionDescriptor.getLDAPUrl());
            try {
                InetAddress[] hostAddresses = InetAddress.getAllByName(this.connectionDescriptor.getHostname());
                InetAddress localHost = InetAddress.getLocalHost();
                for (InetAddress element : hostAddresses) {
                    if (!element.isLoopbackAddress() && !element.equals(localHost)) continue;
                    env.put("ldap.mapping.single-treaded", Boolean.TRUE);
                    break;
                }
            }
            catch (UnknownHostException e) {
                logger.error((Object)e);
            }
            this.ldapEnvironment = new UnmodifiableHashtable<Object, Object>(env);
        }
        return this.ldapEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameParser getNameParser() throws NamingException {
        if (null == this.nameParser) {
            LdapContext ctx = this.createDirContext();
            try {
                this.nameParser = ctx.getNameParser("");
            }
            finally {
                ctx.close();
            }
        }
        return this.nameParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnectionDescriptor.DirectoryType guessDirectoryType() throws NamingException {
        if (null == this.directoryType) {
            if (this.connectionDescriptor.getProviderType() == LDAPConnectionDescriptor.ProviderType.APACHE_DS_EMBEDDED) {
                this.dummyDN = "DC=dummy";
                this.directoryType = LDAPConnectionDescriptor.DirectoryType.APACHE_DS;
            } else {
                LdapContext ctx = this.createRootDSEContext();
                try {
                    String vendorName = "";
                    Attribute vendorNameAttr = ctx.getAttributes("", new String[]{"vendorName"}).get("vendorName");
                    if (null != vendorNameAttr) {
                        vendorName = vendorNameAttr.get().toString();
                    }
                    if (vendorName.toUpperCase().startsWith("APACHE")) {
                        this.dummyDN = "DC=dummy";
                        LDAPConnectionDescriptor.DirectoryType directoryType = this.directoryType = LDAPConnectionDescriptor.DirectoryType.APACHE_DS;
                        return directoryType;
                    }
                    Attribute dsServiceNameAttr = ctx.getAttributes("", new String[]{"dsServiceName"}).get("dsServiceName");
                    if (null != dsServiceNameAttr) {
                        this.dummyDN = this.getDummyDN(ctx);
                        LDAPConnectionDescriptor.DirectoryType directoryType = this.directoryType = LDAPConnectionDescriptor.DirectoryType.MS_2003R2;
                        return directoryType;
                    }
                    Attribute oc = ctx.getAttributes("", new String[]{"objectClass"}).get("objectClass");
                    NamingEnumeration<?> nm = oc.getAll();
                    while (nm.hasMoreElements()) {
                        String value = nm.next().toString();
                        if (!value.toUpperCase().startsWith("OPENLDAPROOTDSE")) continue;
                        this.directoryType = LDAPConnectionDescriptor.DirectoryType.OPEN_LDAP;
                        this.dummyDN = "DC=dummy";
                        LDAPConnectionDescriptor.DirectoryType directoryType = this.directoryType;
                        return directoryType;
                    }
                    if (null == this.directoryType) {
                        throw new NamingException("Unrecognized directory server");
                    }
                }
                finally {
                    ctx.close();
                }
            }
        }
        return this.directoryType;
    }

    public boolean contains(Name name) throws NamingException {
        return name.startsWith(this.getBaseDNName());
    }

    public LdapContext createDirContext() throws NamingException {
        while (true) {
            try {
                return new InitialLdapContext(this.getLDAPEnv(), null);
            }
            catch (AuthenticationException e) {
                if (this.connectionDescriptor.getCallbackHandler() instanceof CachingCallbackHandler) {
                    try {
                        ((CachingCallbackHandler)this.connectionDescriptor.getCallbackHandler()).purgeCache();
                        this.ldapEnvironment = null;
                    }
                    catch (Exception e1) {
                        throw new NamingException("Authentication with directory failed: " + e1 + " (was: " + e + ")");
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private LdapContext createRootDSEContext() throws NamingException {
        while (true) {
            try {
                Hashtable<Object, Object> env = new Hashtable<Object, Object>(this.getLDAPEnv());
                env.put("java.naming.provider.url", this.getLDAPUrlForRootDSE());
                return new InitialLdapContext(env, null);
            }
            catch (AuthenticationException e) {
                if (this.connectionDescriptor.getCallbackHandler() instanceof CachingCallbackHandler) {
                    try {
                        ((CachingCallbackHandler)this.connectionDescriptor.getCallbackHandler()).purgeCache();
                    }
                    catch (Exception e1) {
                        throw new NamingException("Authentication with directory failed: " + e1 + " (was: " + e + ")");
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void populateDefaultEnv(Hashtable<Object, Object> env) {
        env.put("java.naming.factory.initial", this.connectionDescriptor.getProviderType().getClassName());
        env.put("java.naming.referral", this.connectionDescriptor.getReferralPreference());
        env.put("java.naming.batchsize", "100");
    }

    private String getLDAPUrlForRootDSE() {
        switch (this.connectionDescriptor.getProviderType()) {
            default: {
                return (this.connectionDescriptor.getConnectionMethod() != LDAPConnectionDescriptor.ConnectionMethod.SSL ? "ldap" : "ldaps") + "://" + this.connectionDescriptor.getHostname() + ":" + this.connectionDescriptor.getPortNumber();
            }
            case APACHE_DS_EMBEDDED: 
        }
        return "";
    }

    private String getDummyDN(DirContext ctx) throws NamingException {
        Attributes dummyMember = ctx.getAttributes("", new String[]{"rootDomainNamingContext"});
        String nextDummy = "";
        NamingEnumeration<String> e = dummyMember.getIDs();
        while (e != null && e.hasMore()) {
            nextDummy = e.next();
        }
        return dummyMember.get(nextDummy).get().toString();
    }

    public String fixNameCase(String memberDN) throws NamingException {
        if (!this.guessDirectoryType().requiresUpperCaseRDNAttributeNames()) {
            return memberDN;
        }
        Name parsed = this.getNameParser().parse(memberDN);
        Object adjusted = null;
        Enumeration<String> e = parsed.getAll();
        while (e.hasMoreElements()) {
            String part = e.nextElement();
            int idx = part.indexOf(61);
            char[] c = part.toCharArray();
            for (int i = 0; i < idx; ++i) {
                c[i] = Character.toUpperCase(c[i]);
            }
            part = new String(c);
            if (null == adjusted) {
                adjusted = this.getNameParser().parse(part);
                continue;
            }
            adjusted.add(part);
        }
        return adjusted.toString();
    }

    public Name makeAbsoluteName(String name) throws NamingException {
        Name parsedName = this.getNameParser().parse(name);
        if (!this.contains(parsedName)) {
            parsedName.addAll(0, this.getBaseDNName());
        }
        return parsedName;
    }

    public Name makeRelativeName(String name) throws NamingException {
        Name parsedName = this.getNameParser().parse(name);
        if (!parsedName.startsWith(this.getBaseDNName())) {
            return parsedName;
        }
        if (this.getBaseDNName().size() == 0) {
            return parsedName;
        }
        return parsedName.getSuffix(this.getBaseDNName().size());
    }

    public String getDummyMember() throws NamingException {
        if (null == this.dummyDN) {
            this.guessDirectoryType();
        }
        return this.dummyDN;
    }

    public boolean isDummyMember(String dn) {
        return this.dummyDN.equalsIgnoreCase(dn);
    }

    public boolean isReadOnly() {
        return this.connectionDescriptor.isReadOnly();
    }

    public Name makeAbsoluteName(Name name) throws InvalidNameException {
        if (this.baseDNName.startsWith(name)) {
            return name;
        }
        return ((Name)this.baseDNName.clone()).addAll(name);
    }
}

