/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.text.MessageFormat;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DiropLogger {
    private final Logger readLogger;
    private final Logger writeLogger;
    public static DiropLogger LOG = new DiropLogger(DiropLogger.class.getPackage().getName() + ".DIROP");

    private DiropLogger(String prefix) {
        this.readLogger = Logger.getLogger((String)(prefix + ".READ"));
        this.writeLogger = Logger.getLogger((String)(prefix + ".WRITE"));
    }

    public boolean isReadEnabled() {
        return this.readLogger.isDebugEnabled();
    }

    public boolean isWriteEnabled() {
        return this.writeLogger.isDebugEnabled();
    }

    public void logModify(Name dn, ModificationItem[] mods, String comment) {
        if (this.isWriteEnabled()) {
            this.logModify(dn.toString(), mods, comment);
        }
    }

    public void logModify(String dn, ModificationItem[] mods, String comment) {
        if (this.isWriteEnabled()) {
            try {
                this.writeLogger.debug((Object)("# " + comment));
                this.writeLogger.debug((Object)("dn: " + dn));
                this.writeLogger.debug((Object)"changetype: modify");
                for (ModificationItem mi : mods) {
                    String id = mi.getAttribute().getID();
                    switch (mi.getModificationOp()) {
                        case 1: {
                            this.writeLogger.debug((Object)("add: " + id));
                            break;
                        }
                        case 3: {
                            this.writeLogger.debug((Object)("remove: " + id));
                            break;
                        }
                        case 2: {
                            this.writeLogger.debug((Object)("replace: " + id));
                        }
                    }
                    NamingEnumeration<?> e = mi.getAttribute().getAll();
                    while (e.hasMore()) {
                        this.writeLogger.debug((Object)(id + ": " + e.next()));
                    }
                    this.writeLogger.debug((Object)"-");
                }
                this.writeLogger.debug((Object)"");
            }
            catch (Exception e) {
                this.writeLogger.error((Object)"Can't log operation: ", (Throwable)e);
            }
        }
    }

    public void logAdd(Name dn, Attributes attributes, String comment) {
        if (this.isWriteEnabled()) {
            this.logAdd(dn.toString(), attributes, comment);
        }
    }

    public void logAdd(String dn, Attributes attributes, String comment) {
        if (this.isWriteEnabled()) {
            try {
                this.writeLogger.debug((Object)("# " + comment));
                this.writeLogger.debug((Object)("dn: " + dn));
                this.writeLogger.debug((Object)"changetype: add");
                this.logAttributes(attributes);
                this.writeLogger.debug((Object)"");
            }
            catch (NamingException e) {
                this.writeLogger.error((Object)"Can't log operation: ", (Throwable)e);
            }
        }
    }

    public void logDelete(Name dn, String comment) {
        if (this.isWriteEnabled()) {
            this.logDelete(dn.toString(), comment);
        }
    }

    public void logDelete(String dn, String comment) {
        if (this.isWriteEnabled()) {
            this.writeLogger.debug((Object)("# " + comment));
            this.writeLogger.debug((Object)("dn: " + dn));
            this.writeLogger.debug((Object)"changetype: delete");
            this.writeLogger.debug((Object)"");
        }
    }

    private void logAttributes(Attributes attributes) throws NamingException {
        NamingEnumeration<? extends Attribute> e = attributes.getAll();
        while (e.hasMore()) {
            Attribute a = e.next();
            String id = a.getID();
            NamingEnumeration<?> f = a.getAll();
            while (f.hasMore()) {
                this.writeLogger.debug((Object)(id + ": " + f.next()));
            }
        }
    }

    public void logModRDN(Name oldName, Name newName, String comment) {
        if (this.isWriteEnabled()) {
            this.writeLogger.debug((Object)("# " + comment));
            this.writeLogger.debug((Object)("dn: " + oldName.toString()));
            this.writeLogger.debug((Object)"changetype: modrdn");
            this.writeLogger.debug((Object)("newrdn: " + newName.get(newName.size() - 1)));
            this.writeLogger.debug((Object)"");
        }
    }

    public void enable(boolean read, boolean write) {
        this.readLogger.setLevel(read ? Level.DEBUG : Level.WARN);
        this.writeLogger.setLevel(write ? Level.DEBUG : Level.WARN);
    }

    public void logReadComment(String pattern, Object ... args) {
        if (this.isReadEnabled()) {
            this.readLogger.debug((Object)MessageFormat.format("# " + pattern, args));
        }
    }

    public void logGetAttributes(Name name, String[] attributes, String comment) {
        if (this.isReadEnabled()) {
            this.logGetAttributes(name.toString(), attributes, comment);
        }
    }

    public void logGetAttributes(String dn, String[] attributes, String comment) {
        if (this.isReadEnabled()) {
            this.readLogger.debug((Object)("# GET ATTRIBUTES: " + comment));
            this.readLogger.debug((Object)("# dn: " + dn));
            if (null != attributes) {
                StringBuilder sb = new StringBuilder("# fetching only: ");
                for (String s : attributes) {
                    sb.append(s).append(" ");
                }
                this.readLogger.debug((Object)sb.toString());
            }
            this.readLogger.debug((Object)"");
        }
    }

    public void logSearch(String dn, String filter, Object[] filterArgs, SearchControls sc, String comment) {
        if (this.isReadEnabled()) {
            this.readLogger.debug((Object)("# SEARCH: " + comment));
            this.readLogger.debug((Object)("# base: " + dn));
            this.readLogger.debug((Object)("# filter: " + filter));
            if (null != filterArgs) {
                for (Object arg : filterArgs) {
                    this.readLogger.debug((Object)("#    " + arg));
                }
            }
            this.readLogger.debug((Object)("# scope: " + (sc.getSearchScope() == 0 ? "object" : (sc.getSearchScope() == 1 ? "onelevel" : "sub")) + " timelimit: " + sc.getTimeLimit() + " countlimit: " + sc.getCountLimit()));
            this.readLogger.debug((Object)"");
        }
    }
}

