/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import org.openthinclient.ldap.AttributeMapping;
import org.openthinclient.ldap.Cardinality;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DiropLogger;
import org.openthinclient.ldap.OneToManyMapping;
import org.openthinclient.ldap.Transaction;
import org.openthinclient.ldap.TypeMapping;

public final class GroupMapping
extends TypeMapping {
    private final String memberAttribute;
    private AttributeMapping memberMapping;

    public GroupMapping(String className, String baseDN, String searchFilter, String objectClasses, String keyClass, String memberAttribute) throws ClassNotFoundException {
        super(className, baseDN, searchFilter, objectClasses, keyClass);
        this.memberAttribute = memberAttribute;
    }

    public void addMembers(AttributeMapping memberAttribute) {
        this.add(memberAttribute);
    }

    void addMember(Object group, String memberField, String memberDN, Transaction tx) throws DirectoryException, NamingException {
        Attribute membersAttribute;
        memberDN = this.getDirectoryFacade().fixNameCase(memberDN);
        DirContext ctx = tx.getContext(this.getDirectoryFacade());
        String groupDN = this.getDN(group);
        Name groupName = this.getDirectoryFacade().makeRelativeName(groupDN);
        ModificationItem mod = null;
        if (this.memberMapping.cardinality == Cardinality.ONE_OR_MANY && !memberField.equals("member") && !memberField.equals("memberOf") && null != (membersAttribute = ctx.getAttributes(groupName, new String[]{memberField}).get(this.memberAttribute))) {
            String dummy = this.getDirectoryFacade().getDummyMember();
            if (membersAttribute.contains(dummy)) {
                membersAttribute.remove(dummy);
            }
            membersAttribute.add(memberDN);
            mod = new ModificationItem(2, membersAttribute);
        }
        if (null == mod) {
            mod = new ModificationItem(1, new BasicAttribute(memberField, memberDN));
        }
        ModificationItem[] mods = new ModificationItem[]{mod};
        DiropLogger.LOG.logModify(groupDN, mods, "add member to group");
        ctx.modifyAttributes(this.getDirectoryFacade().makeRelativeName(groupDN), mods);
    }

    void removeMember(Object group, String memberField, String memberDN, Transaction tx) throws DirectoryException, NamingException {
        memberDN = this.getDirectoryFacade().fixNameCase(memberDN);
        DirContext ctx = tx.getContext(this.getDirectoryFacade());
        String groupDN = this.getDN(group);
        Name groupName = this.getDirectoryFacade().makeRelativeName(groupDN);
        ModificationItem mod = null;
        if (this.memberMapping.cardinality == Cardinality.ONE_OR_MANY && !memberField.equals("member") && !memberField.equals("memberOf")) {
            Attribute membersAttribute = ctx.getAttributes(groupName, new String[]{memberField}).get(this.memberAttribute);
            if (null == membersAttribute) {
                mod = new ModificationItem(1, new BasicAttribute(memberField, this.getDirectoryFacade().getDummyMember()));
            } else {
                membersAttribute.remove(memberDN);
                if (membersAttribute.size() == 0) {
                    membersAttribute.add(this.getDirectoryFacade().getDummyMember());
                }
                mod = new ModificationItem(2, membersAttribute);
            }
        }
        if (null == mod) {
            mod = new ModificationItem(3, new BasicAttribute(memberField, memberDN));
        }
        ModificationItem[] mods = new ModificationItem[]{mod};
        DiropLogger.LOG.logModify(groupDN, mods, "remove member from group");
        ctx.modifyAttributes(this.getDirectoryFacade().makeRelativeName(groupDN), mods);
    }

    public boolean isInDirectory(Object group, String memberField, String dn, Transaction tx) throws NamingException, DirectoryException {
        DirContext ctx = tx.getContext(this.getDirectoryFacade());
        String groupDN = this.getDN(group);
        Attributes attrs = ctx.getAttributes(this.getDirectoryFacade().makeRelativeName(groupDN), new String[]{memberField});
        Attribute a = attrs.getAll().next();
        for (int k = 0; k <= a.size() - 1; ++k) {
            String as = a.get(k).toString();
            if (!as.equalsIgnoreCase(dn)) continue;
            return true;
        }
        return false;
    }

    public void initPostLoad() {
        super.initPostLoad();
        for (AttributeMapping am : this.attributes) {
            if (!am.fieldName.equals(this.memberAttribute)) continue;
            if (am instanceof OneToManyMapping) {
                this.memberMapping = am;
                break;
            }
            throw new IllegalStateException("MemberAttribute " + this.memberAttribute + " of GroupMapping " + this.getMappedType() + " is not mapped using one-to-many");
        }
        if (null == this.memberMapping) {
            throw new IllegalStateException("MemberAttribute " + this.memberAttribute + " of GroupMapping missing corresponding one-to-many mapping");
        }
    }
}

